/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueueReader
extends BufferedReader {
    private static final String EMPTY_STRING = "";
    private static final byte[] EMPTY_BYTE_ARRAY = "".getBytes();
    public static final UnsupportedOperationException use = new UnsupportedOperationException("Only the readLine and ready operations are supported on this reader");
    private ConcurrentLinkedQueue<String> messageQ;

    public QueueReader(ConcurrentLinkedQueue<String> queue) {
        super(new InputStreamReader(new ByteArrayInputStream(EMPTY_BYTE_ARRAY)));
        this.messageQ = queue;
    }

    @Override
    public String readLine() throws IOException {
        String messageOnTop = this.messageQ.poll();
        if (messageOnTop == null) {
            return null;
        }
        return messageOnTop;
    }

    @Override
    public boolean ready() throws IOException {
        return !this.messageQ.isEmpty();
    }

    @Override
    public int read() throws IOException {
        throw use;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw use;
    }

    @Override
    public long skip(long n) throws IOException {
        throw use;
    }

    @Override
    public boolean markSupported() {
        throw use;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw use;
    }

    @Override
    public void reset() throws IOException {
        throw use;
    }

    @Override
    public void close() throws IOException {
        this.messageQ.clear();
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        throw use;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        throw use;
    }
}

