/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.IOutputPropertyGatherer;
import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutputPropertyGatherer
implements IOutputPropertyGatherer,
IStreamConsumer {
    private static final String PROPERTY_PREFIX = "[output.param.";
    private static final String PROPERTY_ENCLOSING_BRACE = "]";
    private Map<String, String> properties = new HashMap<String, String>();
    private static Logger logger = LogManager.getLogger((String)OutputPropertyGatherer.class.getName());
    private volatile boolean isActive = true;

    public OutputPropertyGatherer(Set<String> propertyNames) {
        if (propertyNames == null) {
            return;
        }
        for (String name : propertyNames) {
            this.properties.put(name, "");
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperty(String name, String value) {
        if (this.properties.containsKey(name)) {
            logger.debug("Adding property " + name + "=" + value);
            this.properties.put(name, value);
        } else {
            logger.debug("Ignoring property " + name + "=" + value);
        }
    }

    @Override
    public void consumeLine(String line) {
        int end;
        int start;
        if (this.isActive() && (start = line.indexOf(PROPERTY_PREFIX)) >= 0 && (end = line.indexOf(PROPERTY_ENCLOSING_BRACE, start + PROPERTY_PREFIX.length())) > 0) {
            String property = line.substring(start + PROPERTY_PREFIX.length(), end);
            String[] split = property.split("=");
            logger.debug("Found output property expresion " + property);
            if (split.length == 2) {
                this.setProperty(split[0], split[1]);
            } else {
                logger.debug("Ignoring output property expresion " + property);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    void deactivate() {
        this.isActive = false;
    }
}

