/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.task;

import com.singularity.ee.agent.systemagent.api.AJavaTask;
import com.singularity.ee.agent.systemagent.api.ISelfManagedTask;
import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.task.classloading.CompatibilityClassLoaderModule;
import com.singularity.ee.agent.systemagent.task.sigar.SigarDelegate;
import com.singularity.ee.task.JavaTaskMetaData;
import com.singularity.ee.util.loader.FileSystemClassLoader;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JavaTaskCreator {
    private final JavaTaskMetaData taskMetaData;
    private static Logger logger = LogManager.getLogger((String)JavaTaskCreator.class.getName());
    private FileSystemClassLoader loader;

    public JavaTaskCreator(JavaTaskMetaData taskMetaData) {
        this.taskMetaData = taskMetaData;
    }

    public FileSystemClassLoader getLoader() {
        return this.loader;
    }

    private ClassLoader getExtensionsParentClassLoader() {
        return CompatibilityClassLoaderModule.getExtensionClassLoaderParent();
    }

    public ITask createJavaTask() throws TaskInstantiationException {
        String taskClassPath = this.taskMetaData.getClasspath();
        String taskWorkingDir = this.taskMetaData.getTaskDir();
        String javaMainClass = this.taskMetaData.getImplementationClassName();
        logger.debug("Java Task Data Read ClassPath [" + taskClassPath + "] Working Dir [" + taskWorkingDir + "] Main Class [" + javaMainClass + "]");
        this.loader = new FileSystemClassLoader(this.getExtensionsParentClassLoader(), (ILogger)new Log4JLogger(logger), false);
        this.loader.setIgnoreSecurityExceptionOnDefinePackage(true);
        try {
            if (taskClassPath != null) {
                this.loader.parseAndAddClassPath(taskClassPath, this.taskMetaData.isLoadJarsInClassPathDirs(), taskWorkingDir, true);
            } else {
                logger.info("Task classpath not specified,System classpath will be used.");
            }
        }
        catch (IOException e) {
            logger.error("Error setting up classpath for Java task [" + this.taskMetaData.getName() + "]", (Throwable)e);
            throw new TaskInstantiationException("Could not add classpath entries for task [" + this.taskMetaData.getName() + "]");
        }
        try {
            Class taskMainClass;
            ITask task;
            if (javaMainClass.equals("internal.hardware.monitor")) {
                javaMainClass = SigarDelegate.class.getName();
            }
            if ((task = (ITask)(taskMainClass = this.loader.loadClass(javaMainClass)).newInstance()) instanceof AJavaTask) {
                ((AJavaTask)task).setLoader((ClassLoader)this.loader);
            } else if (task instanceof ISelfManagedTask) {
                ((ISelfManagedTask)task).setClassLoader(this.loader);
            }
            return task;
        }
        catch (ClassNotFoundException e) {
            logger.error("Error loading Main class for Java task [" + this.taskMetaData.getName() + "]", (Throwable)e);
            throw new TaskInstantiationException("Could not load task main class[" + javaMainClass + "] for task [" + this.taskMetaData.getName() + "]");
        }
        catch (ClassCastException e) {
            logger.error("Java Task Main class for Java task [" + this.taskMetaData.getName() + "] does not implement the ITask interface", (Throwable)e);
            throw new TaskInstantiationException("Java Task Main class for Java task [" + this.taskMetaData.getName() + "] does not implement the ITask interface");
        }
        catch (Throwable e) {
            logger.error("Could not load/instantiate the Java Task Main class for Java task [" + this.taskMetaData.getName() + "]", e);
            throw new TaskInstantiationException("Could not load/instantiate task main class[" + javaMainClass + "] for task [" + this.taskMetaData.getName() + "]");
        }
    }
}

