/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.runbook.localscript.requests;

import com.singularity.ee.agent.systemagent.components.monitormanager.AgentMonitorManager;
import com.singularity.ee.agent.systemagent.runbook.localscript.RunLocalScriptActionHandler;
import com.singularity.ee.agent.systemagent.runbook.localscript.RunLocalScriptResponse;
import com.singularity.ee.agent.systemagent.runbook.localscript.requests.RunLocalScriptEventHandler;
import com.singularity.ee.controller.api.constants.AppAgentOperationStatus;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.runbook.RunLocalScriptOperation;
import com.singularity.ee.rest.controller.request.FileUploadRequest;
import com.singularity.ee.util.httpclient.HttpExecutionResponse;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunLocalScriptRequestHandler {
    private static Logger logger = LogManager.getLogger((String)("com.singularity.ops.runbook." + RunLocalScriptRequestHandler.class.getName()));
    private final String controllerHost;
    private final int controllerPort;
    private final String machineId;
    private final String installDir;
    private RunLocalScriptEventHandler eventHandler;

    public RunLocalScriptRequestHandler(String controllerHost, int controllerPort, String machineId, String installDir, AgentMonitorManager agentMonitorManager) {
        this.controllerHost = controllerHost;
        this.controllerPort = controllerPort;
        this.machineId = machineId;
        this.installDir = installDir;
        this.eventHandler = new RunLocalScriptEventHandler(machineId, agentMonitorManager);
    }

    public void handleOperation(RunLocalScriptOperation operation, Map<Long, AppAgentOperationStatus> opIdVsStatus) {
        RunLocalScriptResponse response = null;
        boolean localFailure = false;
        try {
            logger.info("Received run local script request: opId=" + operation.getId() + ", actionGuid=" + operation.getActionGUID());
            response = RunLocalScriptActionHandler.handleOperation(operation, this.installDir);
            this.sendLogs(operation, response);
            this.cleanup(response.getZipFilePath());
        }
        catch (Throwable t) {
            this.logAndSendFailureResponse("Error occurred while executing run local script operation", t, response);
            this.markStatusAsFailed(operation, opIdVsStatus);
            localFailure = true;
        }
        if (!localFailure && response.hasExecutionErrorOccurred()) {
            this.logAndSendFailureResponse("Error occurred while executing run local script operation", response);
            this.markStatusAsFailed(operation, opIdVsStatus);
            return;
        }
        this.logAndSendSuccessResponse("Run local script request completed successfully", response);
        this.markStatusAsSuccessful(operation, opIdVsStatus);
    }

    protected void logAndSendSuccessResponse(String message, RunLocalScriptResponse response) {
        this.eventHandler.logAndSendSuccessResponse(message, response);
    }

    protected void logAndSendFailureResponse(String message, RunLocalScriptResponse response) {
        this.eventHandler.logAndSendFailureResponse(message, response);
    }

    protected void logAndSendFailureResponse(String message, Throwable t, RunLocalScriptResponse response) {
        this.eventHandler.logAndSendFailureResponse(message, t, response);
    }

    private void markStatusAsFailed(RunLocalScriptOperation operation, Map<Long, AppAgentOperationStatus> opIdVsStatus) {
        opIdVsStatus.put(operation.getId(), AppAgentOperationStatus.FAILED);
    }

    private void markStatusAsSuccessful(RunLocalScriptOperation operation, Map<Long, AppAgentOperationStatus> opIdVsStatus) {
        opIdVsStatus.put(operation.getId(), AppAgentOperationStatus.SUCCESSFUL);
    }

    private void cleanup(String zipFilePath) {
        File zipFile = new File(zipFilePath);
        if (!zipFile.exists()) {
            logger.error("Zip file: " + zipFilePath + " DNE.");
        } else if (!zipFile.delete()) {
            logger.error("Failed to delete: " + zipFilePath);
        }
    }

    protected void sendLogs(RunLocalScriptOperation op, RunLocalScriptResponse response) {
        ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>();
        paramsList.add(new NameValuePair("action", "app_agent_operation"));
        paramsList.add(new NameValuePair("operation-id", String.valueOf(op.getId())));
        paramsList.add(new NameValuePair("action-guid", response.getActionGuid()));
        paramsList.add(new NameValuePair("event-guid", response.getEventGuid()));
        paramsList.add(new NameValuePair("rsd-guid", response.getRsdGuid()));
        paramsList.add(new NameValuePair("node-id", (Object)op.getApplicationComponentNodeId()));
        paramsList.add(new NameValuePair("policy-id", response.getPolicyId()));
        FileUploadRequest uploadRequest = new FileUploadRequest(this.controllerHost, this.controllerPort, this.machineId, (ILogger)new Log4JLogger(logger), paramsList);
        File zipFile = new File(response.getZipFilePath());
        if (!zipFile.exists()) {
            logger.error("Log zip does not exist!");
            return;
        }
        uploadRequest.addFile(zipFile);
        HttpExecutionResponse execResponse = uploadRequest.sendRequest();
        if (execResponse.isStatusNotOk() || execResponse.isExceptionHappened()) {
            logger.error(String.format("Failed to send logs ZIP to controller: %s", execResponse.getExceptionMessage()));
        }
    }
}

