/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.runbook.localscript.executor;

import com.singularity.ee.agent.systemagent.runbook.localscript.executor.ProcessOutputCallback;
import com.singularity.ee.agent.systemagent.runbook.localscript.executor.ScriptExecutorConstants;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptExecutor
implements ScriptExecutorConstants {
    private static final Logger logger = LogManager.getLogger((String)("com.singularity.ops.runbook." + ScriptExecutor.class.getSimpleName()));
    protected Map<String, String> environment;
    protected String scriptPath;
    private String canonicalScriptPath;
    private String workingDirectory;
    private String canonicalWorkingDirectory;
    private String[] scriptArgs;
    private boolean logToFile;
    private boolean logToConsole;
    private boolean isWorkingDirectorySet;
    private boolean mergeStdErr;
    protected int timeout = 120;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private ProcessBuilder pb;
    private Process p;
    private List<Future<StringBuilder>> outputCallbackFutures = new ArrayList<Future<StringBuilder>>();
    private ExecutorService callbackPool;
    private ExecutorService processExecutor = Executors.newSingleThreadExecutor();
    private int exitCode;
    private StringBuilder firstNLines;
    private List<String> outputFilePaths;
    private CountDownLatch latch;
    private Date start;
    private boolean errorOccurredDuringExecution;
    private String errorMessage;
    private Throwable throwable;

    private ScriptExecutor() {
        this.callbackPool = Executors.newFixedThreadPool(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("process-callback");
                return thread;
            }
        });
        this.latch = new CountDownLatch(1);
        this.outputFilePaths = new ArrayList<String>();
    }

    ScriptExecutor(String ... scriptArgs) {
        this();
        this.scriptArgs = scriptArgs == null ? null : (String[])scriptArgs.clone();
    }

    void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    void setScriptArgs(String[] scriptArgs) {
        this.scriptArgs = scriptArgs == null ? null : (String[])scriptArgs.clone();
    }

    void setMergeStdErr(boolean mergeStdErr) {
        this.mergeStdErr = mergeStdErr;
    }

    void setLogToFile(boolean logToFile) {
        this.logToFile = logToFile;
    }

    void setLogToConsole(boolean logToConsole) {
        this.logToConsole = logToConsole;
    }

    void setWorkingDirectorySet(boolean workingDirectorySet) {
        this.isWorkingDirectorySet = workingDirectorySet;
    }

    public boolean hasErrorOccurredDuringExecution() {
        return this.errorOccurredDuringExecution;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    void setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public StringBuilder getFirstNLines() {
        return this.firstNLines;
    }

    public List<String> getOutputFilePaths() {
        return this.outputFilePaths;
    }

    public void execute() {
        this.p = null;
        try {
            if (!this.isWorkingDirectorySet) {
                this.errorOccurredDuringExecution = true;
                this.errorMessage = "The system property 'singularity.install.dir' must be set to the machine agent install directory for local script actions to function";
                logger.error(this.errorMessage);
                return;
            }
            File file = new File(this.workingDirectory);
            if (!file.exists()) {
                this.errorOccurredDuringExecution = true;
                this.errorMessage = "Working directory: " + this.workingDirectory + " DNE";
                logger.error(this.errorMessage);
                return;
            }
            this.canonicalWorkingDirectory = file.getCanonicalPath();
            this.canonicalScriptPath = this.canonicalizeScriptPath(this.scriptPath);
            if (this.canonicalScriptPath == null) {
                return;
            }
            this.createProcessBuilder();
            logger.info("Executing: " + String.valueOf(this.pb.command()));
            if (this.workingDirectory != null) {
                logger.info("Using working directory: " + this.workingDirectory);
            } else {
                logger.info("Using working directory: " + System.getProperty("user.dir"));
            }
            if (this.mergeStdErr) {
                this.pb.redirectErrorStream(true);
            }
            this.p = this.pb.start();
            this.start = new Date();
            this.submitProcessOutputCallbacks();
            this.exitCode = this.timedCall(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    int result = ScriptExecutor.this.p.waitFor();
                    ScriptExecutor.this.latch.countDown();
                    return result;
                }
            }, this.timeout, this.timeoutUnit);
        }
        catch (Throwable e) {
            this.haltScriptExecution();
            this.throwable = e;
            this.errorOccurredDuringExecution = true;
            this.errorMessage = "Error occurred while running script";
            logger.error(this.errorMessage + ": " + Arrays.toString(this.scriptArgs), e);
        }
        finally {
            if (!(this.callbackPool == null || this.callbackPool.isShutdown() && this.callbackPool.isTerminated())) {
                this.callbackPool.shutdownNow();
            }
            if (!(this.processExecutor == null || this.processExecutor.isShutdown() && this.processExecutor.isTerminated())) {
                this.processExecutor.shutdownNow();
            }
        }
    }

    private String canonicalizeScriptPath(String scriptPath) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Working directory: " + this.canonicalWorkingDirectory);
        }
        String machineAgentJailPath = this.canonicalWorkingDirectory + File.separator + "local-scripts";
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            this.errorOccurredDuringExecution = true;
            this.errorMessage = String.format("File %s does not exist", scriptPath);
            logger.error(this.errorMessage);
            return null;
        }
        String path = scriptFile.getCanonicalPath();
        if (!path.startsWith(machineAgentJailPath)) {
            this.errorOccurredDuringExecution = true;
            this.errorMessage = "Script '" + path + "' must reside in '" + this.canonicalWorkingDirectory + File.separator + "local-scripts'";
            logger.error(this.errorMessage);
            return null;
        }
        return path;
    }

    private <T> T timedCall(Callable<T> callable, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<T> task = new FutureTask<T>(callable);
        this.processExecutor.execute(task);
        return task.get(timeout, timeUnit);
    }

    public void blockUntilScriptCompletes() {
        if (this.errorOccurredDuringExecution) {
            return;
        }
        try {
            if (this.mergeStdErr) {
                if (!this.outputCallbackFutures.isEmpty()) {
                    Future<StringBuilder> future = this.outputCallbackFutures.get(this.outputCallbackFutures.size() - 1);
                    try {
                        this.firstNLines = future.get();
                    }
                    catch (Throwable t) {
                        this.errorMessage = "Error occurred while collecting script output";
                        this.errorOccurredDuringExecution = true;
                        this.throwable = t;
                        logger.error(this.errorMessage, t);
                    }
                }
            } else {
                for (Future<StringBuilder> outputCallbackFuture : this.outputCallbackFutures) {
                    outputCallbackFuture.get();
                }
            }
            this.latch.await();
        }
        catch (ExecutionException e) {
            logger.error("Error occurred while processing script output.", e.getCause());
        }
        catch (InterruptedException e) {
            logger.warn("Encountered an error while waiting for script completion.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void createProcessBuilder() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.canonicalScriptPath);
        Collections.addAll(args, this.scriptArgs);
        this.pb = new ProcessBuilder(args);
        if (this.isWorkingDirectorySet) {
            File file = new File(this.workingDirectory);
            this.pb.directory(file);
        }
        if (this.environment != null) {
            this.pb.environment().putAll(this.environment);
        }
    }

    private void haltScriptExecution() {
        if (this.p != null) {
            this.p.destroy();
        }
        this.pb = null;
        for (Future<StringBuilder> future : this.outputCallbackFutures) {
            try {
                future.cancel(true);
            }
            catch (Exception e) {
                logger.error("Error occurred while cancelling output callbacks", (Throwable)e);
            }
        }
        this.callbackPool.shutdownNow();
        this.processExecutor.shutdownNow();
    }

    private void submitProcessOutputCallbacks() {
        if (this.mergeStdErr) {
            String fileName = this.getMergedOutputFileName();
            this.outputFilePaths.add(fileName);
            this.outputCallbackFutures.add(this.callbackPool.submit(new ProcessOutputCallback(this.p.getInputStream(), 10, 0xA00000, this.logToConsole, this.logToFile, fileName)));
        } else {
            String fileName = this.getUnMergedOutputFileName(false);
            this.outputFilePaths.add(fileName);
            this.outputCallbackFutures.add(this.callbackPool.submit(new ProcessOutputCallback(this.p.getInputStream(), this.logToConsole, this.logToFile, fileName)));
            fileName = this.getUnMergedOutputFileName(true);
            this.outputFilePaths.add(fileName);
            this.outputCallbackFutures.add(this.callbackPool.submit(new ProcessOutputCallback(this.p.getErrorStream(), this.logToConsole, this.logToFile, fileName)));
        }
    }

    private String getUnMergedOutputFileName(boolean stderr) {
        if (!this.logToFile) {
            return null;
        }
        String streamQualifier = stderr ? "STDERR" : "STDOUT";
        return String.format("%s_%s_%s.log", this.scriptPath, streamQualifier, this.getTimeStampSuffix());
    }

    private String getMergedOutputFileName() {
        if (!this.logToFile) {
            return null;
        }
        return String.format("%s_%s.log", this.scriptPath, this.getTimeStampSuffix());
    }

    private String getTimeStampSuffix() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss");
        return dateFormat.format(this.start);
    }
}

