/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.handler;

import com.singularity.ee.agent.configuration.identity.AgentIdentity;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.systemagent.components.monitormanager.AgentMonitorManager;
import com.singularity.ee.agent.systemagent.handler.AMachineAgentComponentInitializer;
import com.singularity.ee.agent.systemagent.handler.RequestHandlerContext;
import com.singularity.ee.agent.systemagent.task.util.TaskExecuteServerRequestHandlerFactory;
import com.singularity.ee.agent.systemagent.task.util.TaskInstallServerRequestHandlerFactory;
import com.singularity.ee.transport.onewayagent.AgentTransport;
import com.singularity.ee.transport.onewayagent.IServerRequestHandlerFactory;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.util.Map;

public class OneWayAgentInitializer
extends AMachineAgentComponentInitializer<AgentTransport> {
    private final RequestHandlerContext requestHandlerContext;
    private final boolean orchestrationEnabled;
    private final ILogger logger;

    public OneWayAgentInitializer(AgentIdentity agentIdentity, ControllerInfo controllerInfo, AgentMonitorManager agentMonitorManager, RequestHandlerContext requestHandlerContext, boolean orchestrationEnabled, ILogger logger, boolean override) {
        super(agentIdentity, controllerInfo, agentMonitorManager, "One-Way Agent", logger, override);
        this.requestHandlerContext = requestHandlerContext;
        this.orchestrationEnabled = orchestrationEnabled;
        this.logger = logger;
    }

    @Override
    public AgentTransport initializeComponent() {
        AgentTransport agentTransport = null;
        if (this.orchestrationEnabled) {
            this.logger.info("Orchestration is enabled - setting up one-way agent transport so the agent may execute workflow tasks ->" + String.valueOf(this.agentIdentity));
            agentTransport = new AgentTransport(this.agentIdentity.getControllerHost(), this.agentIdentity.getControllerPort(), this.agentIdentity.getMachineInstanceID(), this.logger);
            Map<String, Object> handlerContext = this.requestHandlerContext.getAttributeMap();
            String tempDir = (String)handlerContext.get("Agent-Temp-Dir");
            String tasksRootDir = (String)handlerContext.get("Agent-Tasks-Root-Dir");
            IAgentScheduledExecutorService scheduler = (IAgentScheduledExecutorService)handlerContext.get("Agent-Scheduler");
            TaskInstallServerRequestHandlerFactory installFactory = new TaskInstallServerRequestHandlerFactory(tempDir, tasksRootDir);
            TaskExecuteServerRequestHandlerFactory executeFactory = new TaskExecuteServerRequestHandlerFactory(scheduler, tasksRootDir);
            agentTransport.registerServerRequestHandlerFactory((IServerRequestHandlerFactory)installFactory);
            agentTransport.registerServerRequestHandlerFactory((IServerRequestHandlerFactory)executeFactory);
            agentTransport.start();
        } else {
            this.logger.info("Orchestration is disabled - disabling one-way agent transport. The agent will not be able to execute workflow tasks.");
        }
        return agentTransport;
    }
}

