/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.handler;

import com.singularity.ee.agent.configuration.identity.AgentIdentity;
import com.singularity.ee.agent.resolver.ControllerInfo;
import com.singularity.ee.agent.systemagent.components.monitormanager.AgentMonitorManager;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.EventCorrelationType;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.events.MachineEventData;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.string.StringOperations;

public abstract class AMachineAgentComponentInitializer<T> {
    protected final AgentIdentity agentIdentity;
    protected final ControllerInfo controllerInfo;
    protected final AgentMonitorManager agentMonitorManager;
    private final String componentName;
    private final ILogger logger;
    private final boolean overrideCheck;

    protected AMachineAgentComponentInitializer(AgentIdentity agentIdentity, ControllerInfo controllerInfo, AgentMonitorManager agentMonitorManager, String componentName, ILogger logger, boolean overrideCheck) {
        this.agentIdentity = agentIdentity;
        this.controllerInfo = controllerInfo;
        this.agentMonitorManager = agentMonitorManager;
        this.componentName = componentName;
        this.logger = logger;
        this.overrideCheck = overrideCheck;
    }

    public T setup() {
        if (this.isUsageProhibited()) {
            this.notifyComponentIsDisabled();
            return null;
        }
        return this.initializeComponent();
    }

    protected abstract T initializeComponent();

    private void notifyComponentIsDisabled() {
        String message = String.format("[%s] may only be run through a SaaS controller with SSL enabled", this.componentName);
        this.logger.warn(message);
        MachineEventData event = new MachineEventData();
        String machineInstanceID = this.agentIdentity.getMachineInstanceID();
        long machineID = StringOperations.safeParseLong((String)machineInstanceID);
        event.setSummary(message);
        event.setMachineID(machineID);
        event.setTimestamp(ClockUtils.getCurrentTime());
        EntityDefinition entity = new EntityDefinition();
        entity.setEntityType(EntityType.MACHINE_INSTANCE);
        entity.setEntityId(machineID);
        event.setTriggeredEntity(entity);
        event.addCorrelationID(machineInstanceID, EventCorrelationType.MACHINE_ID);
        this.agentMonitorManager.addMachineAgentEvent(event);
    }

    private boolean isUsageProhibited() {
        if (this.overrideCheck) {
            return false;
        }
        return this.controllerInfo.isSaaS() && !this.controllerInfo.isSslEnabled();
    }
}

