/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.singularity.ee.agent.commonservices.metricgeneration.MetricGenerationService;
import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorDelegate;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorTaskMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorTaskRunner;
import com.singularity.ee.util.javaspecific.threads.IAgentRunnable;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduledTaskRunner
implements IAgentRunnable {
    private final MonitorTaskRunner taskRunner;
    private volatile ITask task;
    private static Logger logger = LogManager.getLogger((String)ScheduledTaskRunner.class.getName());

    public ScheduledTaskRunner(ManagedMonitorTaskMetaData envTaskMetaData, MetricGenerationService metricService, IAgentScheduledExecutorService scheduler, ManagedMonitorDelegate managedMonitorDelegate) throws TaskInstantiationException {
        this.taskRunner = new MonitorTaskRunner(envTaskMetaData, metricService, scheduler, managedMonitorDelegate);
        this.task = this.taskRunner.createTask();
    }

    public void run() {
        try {
            if (this.task == null) {
                this.task = this.taskRunner.createTask();
            }
            this.taskRunner.runTask(this.task);
        }
        catch (TaskExecutionException | TaskInstantiationException e) {
            logger.error("An error occurred while running the task", (Object)e.getMessage());
        }
    }

    public void stop() {
        if (this.task != null) {
            this.task.stop();
        }
    }
}

