/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.singularity.ee.agent.commonservices.metricgeneration.MetricGenerationService;
import com.singularity.ee.agent.systemagent.api.AJavaTask;
import com.singularity.ee.agent.systemagent.api.ISelfManagedTask;
import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.EventOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorDelegate;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorTaskMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorStreamConsumer;
import com.singularity.ee.agent.systemagent.task.ExecTask;
import com.singularity.ee.agent.systemagent.task.JavaTaskCreator;
import com.singularity.ee.agent.systemagent.task.StreamReaderRunnable;
import com.singularity.ee.agent.systemagent.task.TaskThreadPools;
import com.singularity.ee.task.ArgumentMetaData;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.JavaTaskMetaData;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.TaskType;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorTaskRunner {
    public static final String TASK_PROPERTIES_FILE = "task.properties";
    private static final Logger logger = LogManager.getLogger((String)MonitorTaskRunner.class.getName());
    private final ManagedMonitorTaskMetaData managedMonitorTaskMetaData;
    private final MetricGenerationService metricService;
    private final IAgentScheduledExecutorService scheduler;
    private final ManagedMonitorDelegate managedMonitorDelegate;

    public MonitorTaskRunner(ManagedMonitorTaskMetaData managedMonitorTaskMetaData, MetricGenerationService metricService, IAgentScheduledExecutorService scheduler, ManagedMonitorDelegate managedMonitorDelegate) {
        this.managedMonitorTaskMetaData = managedMonitorTaskMetaData;
        this.metricService = metricService;
        this.scheduler = scheduler;
        if (managedMonitorDelegate == null) {
            throw new IllegalArgumentException("managedMonitorDelegate field cannot be null");
        }
        this.managedMonitorDelegate = managedMonitorDelegate;
    }

    public ManagedMonitorTaskMetaData getManagedMonitorTaskMetaData() {
        return this.managedMonitorTaskMetaData;
    }

    public ITask createTask() throws TaskInstantiationException {
        TaskMetaData taskMetaData = this.managedMonitorTaskMetaData.getTaskMetaData();
        if (taskMetaData.getTaskType().equals((Object)TaskType.EXECUTABLE)) {
            ExecTaskMetaData execData = (ExecTaskMetaData)taskMetaData;
            return new ExecTask(execData, this.getTaskArguments(), this.managedMonitorTaskMetaData.getEnvironmentVars());
        }
        if (taskMetaData.getTaskType().equals((Object)TaskType.JAVA)) {
            JavaTaskMetaData javaTaskData = (JavaTaskMetaData)taskMetaData;
            JavaTaskCreator javaTaskCreator = new JavaTaskCreator(javaTaskData);
            ITask task = javaTaskCreator.createJavaTask();
            if (task instanceof ISelfManagedTask) {
                ((ISelfManagedTask)task).init(this.metricService.getMetricAggregatorFactory(), this.scheduler, this.managedMonitorDelegate);
            }
            return task;
        }
        throw new TaskInstantiationException("Invalid Task Type in task meta data " + String.valueOf(taskMetaData));
    }

    public MonitorStreamConsumer setupMetricFeed(ITask task) {
        if (this.managedMonitorTaskMetaData.getTaskMetaData().getTaskType().equals((Object)TaskType.EXECUTABLE)) {
            return this.setupMetricFeed((ExecTask)task);
        }
        return this.setupMetricFeed((AJavaTask)task);
    }

    private MonitorStreamConsumer createStreamConsumer() {
        MonitorStreamConsumer streamConsumer = new MonitorStreamConsumer(this.managedMonitorDelegate.getOutputHandlers());
        return streamConsumer;
    }

    private MonitorStreamConsumer setupMetricFeed(ExecTask execTask) {
        final MonitorStreamConsumer monitorConsumer = this.createStreamConsumer();
        StreamReaderRunnable reader = new StreamReaderRunnable(execTask.getOutputReader());
        StreamReaderRunnable ereader = new StreamReaderRunnable(execTask.getErrorReader());
        reader.addStreamConsumer(monitorConsumer);
        ereader.addStreamConsumer(new IStreamConsumer(){
            private Logger eLogger = LogManager.getLogger((String)this.getClass().getName());

            @Override
            public void consumeLine(String line) {
                if (!EventOutputHandler.handleMachineAgentLogMessage(line)) {
                    this.eLogger.warn("ignoring error line:[" + line + "]");
                }
            }

            @Override
            public boolean isActive() {
                return monitorConsumer.isActive();
            }
        });
        monitorConsumer.addOutputCaptureSchedule(TaskThreadPools.getOutputCaptureThreadPool().scheduleWithFixedDelay(reader, 100L, 50L, TimeUnit.MILLISECONDS), reader);
        monitorConsumer.addOutputCaptureSchedule(TaskThreadPools.getOutputCaptureThreadPool().scheduleWithFixedDelay(ereader, 100L, 50L, TimeUnit.MILLISECONDS), ereader);
        return monitorConsumer;
    }

    private MonitorStreamConsumer setupMetricFeed(AJavaTask javaTask) {
        MonitorStreamConsumer monitorConsumer = this.createStreamConsumer();
        javaTask.addOutStreamConsumer(monitorConsumer);
        return monitorConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(ITask task) throws TaskExecutionException {
        try {
            TaskExecutionContext context = new TaskExecutionContext();
            context.setTaskDir(this.managedMonitorTaskMetaData.getTaskMetaData().getTaskDir());
            ClassLoader backupLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (task instanceof AJavaTask && ((AJavaTask)task).getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(((AJavaTask)task).getLoader());
                }
                task.execute(this.getTaskArguments(), context);
            }
            finally {
                Thread.currentThread().setContextClassLoader(backupLoader);
            }
        }
        catch (TaskInstantiationException e) {
            throw new TaskExecutionException("Error loading task arguments", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getTaskArguments() throws TaskInstantiationException {
        String taskPropertiesFile = this.managedMonitorTaskMetaData.getTaskMetaData().getTaskDir() + File.separator + TASK_PROPERTIES_FILE;
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(taskPropertiesFile);
            props.load(fis);
        }
        catch (IOException e) {
            logger.debug("No task.properties file found for task");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        HashMap<String, String> taskArguments = new HashMap<String, String>();
        List<ArgumentMetaData> argsMetaDataList = this.managedMonitorTaskMetaData.getTaskMetaData().getArgsMetaData();
        for (ArgumentMetaData argumentMetaData : argsMetaDataList) {
            String argValue = this.getArgValue(props, argumentMetaData);
            if (argValue == null && argumentMetaData.isRequired()) {
                throw new TaskInstantiationException("Required Task Argument [" + argumentMetaData.getName() + "] does not have a value, configure value in task.properties");
            }
            taskArguments.put(argumentMetaData.getName(), argValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Task arguments found [" + String.valueOf(taskArguments) + "]");
        }
        return taskArguments;
    }

    private String getArgValue(Properties props, ArgumentMetaData argumentMetaData) {
        String argValue = props.getProperty(argumentMetaData.getName());
        if (argValue == null) {
            return argumentMetaData.getDefaultValue();
        }
        return argValue;
    }
}

