/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ExecutionStyle;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorTaskMetaData;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.InvalidTaskMetaDataException;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.TaskReader;
import com.singularity.ee.task.TaskType;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorTaskReader {
    private static Logger logger = LogManager.getLogger((String)MonitorTaskReader.class.getName());

    public ManagedMonitorTaskMetaData readEnvTaskFromFile(String taskDir, File taskFile) throws InvalidTaskMetaDataException {
        try {
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromFile((File)taskFile);
            return this.readEnvTask(xmlDoc, taskDir);
        }
        catch (IOException e) {
            logger.warn("Error reading task definition from file", (Throwable)e);
            throw new InvalidTaskMetaDataException(e);
        }
        catch (SAXException e) {
            logger.warn("Error reading task definition from file", (Throwable)e);
            throw new InvalidTaskMetaDataException(e);
        }
        catch (ParserConfigurationException e) {
            logger.warn("Error reading task definition from file", (Throwable)e);
            throw new InvalidTaskMetaDataException(e);
        }
    }

    public ManagedMonitorTaskMetaData readEnvTask(Document xmlDoc, String monitorWorkingDir) throws InvalidTaskMetaDataException {
        TaskReader taskReader = new TaskReader();
        TaskMetaData taskMetaData = taskReader.readTaskFromDocument(xmlDoc, monitorWorkingDir);
        String executionStyle = XMLParseUtility.getTextForTagForElement((Node)xmlDoc.getDocumentElement(), (String)"execution-style");
        int executionFrequency = XMLParseUtility.safeParseIntValue((Element)xmlDoc.getDocumentElement(), (String)"execution-frequency-in-seconds");
        ManagedMonitorTaskMetaData metaData = new ManagedMonitorTaskMetaData(taskMetaData, this.getExecutionStyle(executionStyle), executionFrequency);
        metaData.setRestartProcessInSeconds(XMLParseUtility.safeParseIntValue((Element)xmlDoc.getDocumentElement(), (String)"restart-time-in-seconds", (int)-1));
        metaData.setMessageSilenceThresholdInSeconds(XMLParseUtility.safeParseIntValue((Element)xmlDoc.getDocumentElement(), (String)"message-silence-threshold-in-seconds", (int)-1));
        return metaData;
    }

    public ManagedMonitorTaskMetaData readEnvTask(Element element, String monitorWorkingDir) throws InvalidTaskMetaDataException {
        TaskReader taskReader = new TaskReader();
        TaskMetaData taskMetaData = taskReader.readFromTaskElement(element, monitorWorkingDir);
        String executionStyle = XMLParseUtility.getTextForTagForElement((Node)element, (String)"execution-style");
        ExecutionStyle execStyle = this.getExecutionStyle(executionStyle);
        if ((execStyle == ExecutionStyle.CONTINUOUS || execStyle == ExecutionStyle.PERIODIC) && taskMetaData.getTaskType() == TaskType.EXECUTABLE) {
            ((ExecTaskMetaData)taskMetaData).setWaitForProcessExit(true);
        }
        int executionFrequency = XMLParseUtility.safeParseIntValue((Element)element, (String)"execution-frequency-in-seconds");
        ManagedMonitorTaskMetaData mmTaskMetaData = new ManagedMonitorTaskMetaData(taskMetaData, execStyle, executionFrequency);
        mmTaskMetaData.setRestartProcessInSeconds(XMLParseUtility.safeParseIntValue((Element)element, (String)"restart-time-in-seconds", (int)-1));
        mmTaskMetaData.setMessageSilenceThresholdInSeconds(XMLParseUtility.safeParseIntValue((Element)element, (String)"message-silence-threshold-in-seconds", (int)-1));
        return mmTaskMetaData;
    }

    private ExecutionStyle getExecutionStyle(String executionStyle) {
        if (ExecutionStyle.CONTINUOUS.toString().equals(executionStyle.toUpperCase())) {
            return ExecutionStyle.CONTINUOUS;
        }
        if (ExecutionStyle.SCHEDULED.toString().equals(executionStyle.toUpperCase())) {
            return ExecutionStyle.SCHEDULED;
        }
        return ExecutionStyle.PERIODIC;
    }
}

