/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.IMonitorOutputHandler;
import com.singularity.ee.agent.systemagent.task.ITimeout;
import com.singularity.ee.agent.systemagent.task.StreamReaderRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorStreamConsumer
implements IStreamConsumer,
ITimeout {
    private boolean isActive = true;
    private static Logger logger = LogManager.getLogger((String)MonitorStreamConsumer.class.getName());
    private AtomicLong lastMessageReceivedTime = new AtomicLong(System.currentTimeMillis());
    private List<ScheduledFuture<?>> schedules = new ArrayList(2);
    private List<StreamReaderRunnable> streamReaders = new ArrayList<StreamReaderRunnable>(2);
    private Collection<IMonitorOutputHandler> outputHandlers;

    public MonitorStreamConsumer(@NotNull Collection<IMonitorOutputHandler> outputHandlers) {
        this.outputHandlers = outputHandlers;
    }

    @Override
    public void consumeLine(String line) {
        if (line == null || line.equals("")) {
            return;
        }
        this.lastMessageReceivedTime.set(System.currentTimeMillis());
        this.parseAndReportLineForMonitor(line);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public void stop() {
        logger.info("Stopping monitored process");
        this.isActive = false;
        for (ScheduledFuture<?> schedule : this.schedules) {
            schedule.cancel(true);
        }
        for (StreamReaderRunnable streamReader : this.streamReaders) {
            streamReader.run();
        }
    }

    @Override
    public void timeOut(long currentTime) {
        this.isActive = false;
    }

    public long getLastMessageReceivedTime() {
        return this.lastMessageReceivedTime.get();
    }

    public void addOutputCaptureSchedule(ScheduledFuture<?> scheduledFuture, StreamReaderRunnable streamReader) {
        this.schedules.add(scheduledFuture);
        this.streamReaders.add(streamReader);
    }

    private void parseAndReportLineForMonitor(String monitorLine) {
        if (logger.isDebugEnabled()) {
            logger.debug(" Monitor line parsed:" + monitorLine);
        }
        for (IMonitorOutputHandler handler : this.outputHandlers) {
            handler.parseAndReportLine(monitorLine);
        }
    }
}

