/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.appdynamics.voltron.utils.StringUtil;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporterFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorOutputHandler;
import com.singularity.ee.controller.api.constants.MetricClusterRollupType;
import com.singularity.ee.controller.api.constants.MetricHoleHandlingType;
import com.singularity.ee.controller.api.constants.MetricTimeRollupType;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricOutputHandler
extends MonitorOutputHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricOutputHandler.class);
    private final IMetricReporterFactory metricReporter;
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String AGGREGATOR = "aggregator";
    private static final String TIME_ROLLUP = "time-rollup";
    private static final String CLUSTER_ROLLUP = "cluster-rollup";

    public MetricOutputHandler(IMetricReporterFactory metricReporter) {
        this.metricReporter = metricReporter;
    }

    @Override
    public void parseAndReportLine(String monitorLine) {
        if (!monitorLine.startsWith(NAME)) {
            return;
        }
        Map<String, String> metricTokenMap = MetricOutputHandler.createTokenMap(monitorLine);
        String metricName = metricTokenMap.get(NAME);
        String metricValueStr = metricTokenMap.get(VALUE);
        if (StringUtil.isBlank((String)metricName)) {
            log.warn("Extension attempted to print metric with empty name and value {}. Skipping.", (Object)metricValueStr);
        } else if (StringUtil.isBlank((String)metricValueStr)) {
            log.warn("Extension attempted to print metric {} with empty value. Skipping.", (Object)metricName);
        } else {
            try {
                long metricValue = Long.parseLong(metricValueStr);
                MetricAggregatorType aggregator = MetricAggregatorType.AVERAGE;
                MetricTimeRollupType timeRollup = MetricTimeRollupType.AVERAGE;
                MetricClusterRollupType clusterRollup = MetricClusterRollupType.INDIVIDUAL;
                if (metricTokenMap.get(AGGREGATOR) != null) {
                    aggregator = MetricAggregatorType.valueOf((String)metricTokenMap.get(AGGREGATOR));
                }
                if (metricTokenMap.get(TIME_ROLLUP) != null) {
                    timeRollup = MetricTimeRollupType.valueOf((String)metricTokenMap.get(TIME_ROLLUP));
                }
                if (metricTokenMap.get(CLUSTER_ROLLUP) != null) {
                    clusterRollup = MetricClusterRollupType.valueOf((String)metricTokenMap.get(CLUSTER_ROLLUP));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Reporting metric after reading metric [" + metricName + "]");
                }
                this.reportMetric(metricName, metricValue, aggregator, timeRollup, clusterRollup);
            }
            catch (NumberFormatException e) {
                log.warn("Caught NumberFormatException due to invalid metric value: " + metricValueStr + "  It must be a valid long.  Full monitor line: " + monitorLine);
            }
            catch (Exception e) {
                log.warn("Invalid metric output: " + monitorLine, (Throwable)e);
            }
        }
    }

    private void reportMetric(String metricName, long metricValue, MetricAggregatorType aggregator, MetricTimeRollupType timeRollup, MetricClusterRollupType clusterRollup) {
        try {
            AgentRawMetricIdentifier id = new AgentRawMetricIdentifier(metricName, aggregator, timeRollup, clusterRollup, MetricHoleHandlingType.REGULAR_COUNTER);
            IMetricAggregator reporter = this.metricReporter.safeGetAggregator(id);
            if (log.isDebugEnabled()) {
                log.debug("Reporting Metric Name [" + metricName + "] Value [" + metricValue + "]");
            }
            reporter.report(metricValue);
        }
        catch (MetricReporterTypeMismatchException e) {
            log.warn("Metric Reporter type mismatch for metric [" + metricName + "]", (Throwable)e);
        }
        catch (MetricOverflowException e) {
            log.warn("Metric Size exceeded, could not create reporter for [" + metricName + "]", (Throwable)e);
        }
    }
}

