/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager.managed;

import com.singularity.ee.agent.commonservices.metricgeneration.MetricGenerationService;
import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.exception.TaskExecutionException;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorDelegate;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorTaskMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorStreamConsumer;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorTaskRunner;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContinuousTaskRunner
implements Runnable {
    private Logger logger = LogManager.getLogger((String)ContinuousTaskRunner.class.getName());
    private volatile boolean isAlive;
    private volatile ITask task = null;
    private final MonitorTaskRunner taskRunner;
    private long startTime;
    private MonitorStreamConsumer consumer;
    private IAgentScheduledExecutorService scheduler;

    public ContinuousTaskRunner(ManagedMonitorTaskMetaData managedMonitorTaskMetaData, MetricGenerationService metricService, IAgentScheduledExecutorService scheduler, ManagedMonitorDelegate managedMonitorDelegate) throws TaskInstantiationException {
        this.taskRunner = new MonitorTaskRunner(managedMonitorTaskMetaData, metricService, scheduler, managedMonitorDelegate);
        this.task = this.taskRunner.createTask();
        this.scheduler = scheduler;
    }

    public ManagedMonitorTaskMetaData getManagedMonitorTaskMetaData() {
        return this.taskRunner.getManagedMonitorTaskMetaData();
    }

    @Override
    public void run() {
        try {
            this.startTime = System.currentTimeMillis();
            if (this.task == null) {
                this.task = this.taskRunner.createTask();
            }
            this.consumer = this.taskRunner.setupMetricFeed(this.task);
            this.isAlive = true;
            this.taskRunner.runTask(this.task);
        }
        catch (TaskInstantiationException e) {
            this.logger.error("Error creating environment task ", (Throwable)e);
        }
        catch (TaskExecutionException e) {
            this.logger.error("Error running environment task ", (Throwable)e);
        }
        finally {
            this.isAlive = false;
            if (this.task != null) {
                this.task.stop();
                this.task = null;
            }
            this.consumer.stop();
        }
    }

    public boolean isTaskRunning() {
        return this.isAlive;
    }

    public void stop() {
        this.logger.debug("cleaning up continuous script,Stopping output handler for continuous task");
        if (this.task != null) {
            this.task.stop();
            this.isAlive = false;
            this.task = null;
            this.consumer.stop();
            this.consumer = null;
        }
    }

    public long getLastMessageReceivedTime() {
        return this.consumer.getLastMessageReceivedTime();
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.startTime;
    }
}

