/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager;

import com.singularity.ee.agent.systemagent.api.ITask;
import com.singularity.ee.agent.systemagent.api.TaskExecutionContext;
import com.singularity.ee.agent.systemagent.api.exception.TaskInstantiationException;
import com.singularity.ee.agent.systemagent.components.monitormanager.IMonitorDelegate;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorType;
import com.singularity.ee.agent.systemagent.components.monitormanager.UnmanagedMonitorMetaData;
import com.singularity.ee.agent.systemagent.components.monitormanager.exception.MonitorInitializationException;
import com.singularity.ee.agent.systemagent.task.ExecTask;
import com.singularity.ee.agent.systemagent.task.JavaTaskCreator;
import com.singularity.ee.task.ExecTaskMetaData;
import com.singularity.ee.task.JavaTaskMetaData;
import com.singularity.ee.task.TaskMetaData;
import com.singularity.ee.task.TaskType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnmanagedMonitorDelegate
implements IMonitorDelegate {
    private static Logger logger = LogManager.getLogger((String)UnmanagedMonitorDelegate.class.getName());
    private final Map<String, UnmanagedMonitorMetaData> monitors = Collections.synchronizedMap(new HashMap());

    @Override
    public MonitorType getType() {
        return MonitorType.UNMANAGED;
    }

    @Override
    public void initializeMonitor(MonitorMetaData monitorMetaData, Map<String, String> monitorConfig, Map<String, String> environmentVars) throws MonitorInitializationException {
        UnmanagedMonitorMetaData metaData = (UnmanagedMonitorMetaData)monitorMetaData;
        TaskMetaData initTaskMetaData = metaData.getInitTaskMetaData();
        if (!monitorMetaData.isEnabled()) {
            logger.info("Not initializing unmanaged monitor [" + initTaskMetaData.getName() + "] - Disabled in configuration file.");
            return;
        }
        logger.info("Initializing unmanaged monitor [" + initTaskMetaData.getName() + "]");
        try {
            ITask task = this.createTask(initTaskMetaData, monitorConfig);
            task.execute(monitorConfig, new TaskExecutionContext());
            this.monitors.put(monitorMetaData.getName(), metaData);
        }
        catch (Throwable e) {
            logger.warn("Error initializing unmanaged monitor [" + initTaskMetaData.getName() + "]", e);
            throw new MonitorInitializationException(e);
        }
    }

    @Override
    public void initializeMonitor(MonitorMetaData monitorMetaData, Map<String, String> monitorConfig) throws MonitorInitializationException {
        this.initializeMonitor(monitorMetaData, monitorConfig, Collections.emptyMap());
    }

    @Override
    public boolean stopMonitor(String monitorName, Map<String, String> monitorConfig) {
        UnmanagedMonitorMetaData metaData = this.monitors.get(monitorName);
        TaskMetaData stopTaskMetaData = metaData.getInitTaskMetaData();
        try {
            ITask task = this.createTask(stopTaskMetaData, monitorConfig);
            task.execute(monitorConfig, new TaskExecutionContext());
            this.monitors.remove(monitorName);
            return true;
        }
        catch (Throwable e) {
            logger.warn("Error stopping monitor [" + monitorName + "]", e);
            return false;
        }
    }

    private ITask createTask(TaskMetaData taskMetaData, Map<String, String> monitorConfig) throws TaskInstantiationException {
        if (taskMetaData.getTaskType().equals((Object)TaskType.EXECUTABLE)) {
            ExecTaskMetaData execData = (ExecTaskMetaData)taskMetaData;
            return new ExecTask(execData, monitorConfig);
        }
        if (taskMetaData.getTaskType().equals((Object)TaskType.JAVA)) {
            JavaTaskMetaData javaTaskData = (JavaTaskMetaData)taskMetaData;
            JavaTaskCreator javaTaskCreator = new JavaTaskCreator(javaTaskData);
            return javaTaskCreator.createJavaTask();
        }
        throw new TaskInstantiationException("Invalid Task Type in task meta data " + String.valueOf(taskMetaData));
    }

    @Override
    public Set<String> getInstalledMonitors() {
        return this.monitors.keySet();
    }
}

