/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.google.common.collect.ImmutableMap;
import com.singularity.ee.agent.commonservices.timeskewhandling.AControllerTimeSkewHandler;
import com.singularity.ee.agent.configuration.identity.AgentIdentity;
import com.singularity.ee.agent.systemagent.IMachineAgent;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorConfigReader;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorPropertiesFile;
import com.singularity.ee.agent.systemagent.components.monitormanager.UnmanagedMonitorDelegate;
import com.singularity.ee.agent.systemagent.components.monitormanager.exception.InvalidMonitorConfigException;
import com.singularity.ee.agent.systemagent.components.monitormanager.exception.MonitorInitializationException;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.IMonitorOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ISystemAgentMetricSenderFactory;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ManagedMonitorDelegate;
import com.singularity.ee.events.MachineEventData;
import com.singularity.ee.util.io.FileUtil;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeMonitorManager {
    private static final Logger logger = LogManager.getLogger((String)NodeMonitorManager.class.getName());
    private static final String MONITOR_XML = "monitor.xml";
    private static final String UNMANAGED_DIR = "unmanaged";
    private static final String JAVA_HARDWARE_MONITOR = File.separator + "JavaHardwareMonitor";
    private static final String HARDWARE_MONITOR = File.separator + "HardwareMonitor";
    private final String monitorsDir;
    private final BootstrapConfiguration bootstrapConfiguration;
    private volatile UnmanagedMonitorDelegate unmanagedMonitorDelegate;
    private volatile ManagedMonitorDelegate managedMonitorDelegate;

    public NodeMonitorManager(String monitorsDir, AgentIdentity nodeIdentity, AControllerTimeSkewHandler skewHandler, IAgentScheduledExecutorService scheduler, IMachineAgent machineAgent, Collection<IMonitorOutputHandler> additionalOutputHandlers, ISystemAgentMetricSenderFactory senderFactory) {
        this.monitorsDir = monitorsDir;
        this.managedMonitorDelegate = nodeIdentity.getNodeID() == null ? new ManagedMonitorDelegate(scheduler, nodeIdentity.getControllerHost(), nodeIdentity.getControllerPort(), nodeIdentity.getMachineInstanceID(), null, machineAgent.getResolvedHostInfo(), skewHandler, machineAgent, additionalOutputHandlers, senderFactory) : new ManagedMonitorDelegate(scheduler, nodeIdentity.getControllerHost(), nodeIdentity.getControllerPort(), nodeIdentity.getMachineInstanceID(), nodeIdentity.getNodeID(), null, skewHandler, machineAgent, Collections.emptyList(), senderFactory);
        this.unmanagedMonitorDelegate = new UnmanagedMonitorDelegate();
        this.bootstrapConfiguration = machineAgent.getBootstrapConfiguration();
        if (!machineAgent.areServicesDisabledOnStartup()) {
            this.startAllMonitors();
        }
    }

    public void addMachineAgentEvent(MachineEventData machineEventData) {
        this.managedMonitorDelegate.getEventService().addMachineEvent(machineEventData);
    }

    private void readConfig(String monitorsDirectoryPath, boolean unmanaged) {
        File monitorsDirectory = new File(monitorsDirectoryPath);
        if (!monitorsDirectory.exists()) {
            logger.info("Directory [" + monitorsDirectoryPath + "] not found, continuing.");
            return;
        }
        if (monitorsDirectory.exists() && !monitorsDirectory.canRead()) {
            logger.error("Unable to read directory [" + monitorsDirectoryPath + "]. Are the directory permissions set correctly? No monitors will run.");
            return;
        }
        File[] installedMonitors = monitorsDirectory.listFiles();
        if (installedMonitors == null) {
            if (unmanaged) {
                logger.info("No unmanaged monitors installed for this agent.");
            } else {
                logger.info("No managed monitors installed for this agent.");
            }
            return;
        }
        for (File installedMonitor : installedMonitors) {
            ImmutableMap.Builder environmentVars = new ImmutableMap.Builder();
            if (!installedMonitor.isDirectory()) {
                logger.warn("Invalid file in monitor directory " + installedMonitor.getName());
                continue;
            }
            String monitorDir = installedMonitor.getAbsolutePath();
            File monitorConfigFile = new File(monitorDir + File.separator + MONITOR_XML);
            if ((monitorDir.endsWith(JAVA_HARDWARE_MONITOR) || monitorDir.endsWith(HARDWARE_MONITOR)) && this.isSimSupportedOS() && this.bootstrapConfiguration.getSimUserEnabled().booleanValue()) {
                logger.info("Not running legacy system-agent monitor because SIM is enabled.");
                continue;
            }
            if (!monitorConfigFile.exists()) {
                logger.warn("Could not get information for monitor, missing [" + monitorConfigFile.getAbsolutePath() + "] file. Skipping.");
                continue;
            }
            if (!monitorConfigFile.canRead()) {
                logger.error("Unable to read monitor configuration from [" + monitorConfigFile.getAbsolutePath() + "].. Are the file and directory permissions set correctly? Skipping.");
                continue;
            }
            try {
                MonitorConfigReader monitorConfigReader = new MonitorConfigReader(monitorConfigFile.getAbsolutePath(), installedMonitor.getAbsolutePath());
                Map<String, String> monitorProperties = this.readMonitorPropertiesFromDisk(installedMonitor.getName());
                if (monitorProperties != null && !monitorProperties.isEmpty()) {
                    logger.info("Monitor properties read for [" + installedMonitor.getName() + "] -" + String.valueOf(monitorProperties));
                }
                if (unmanaged) {
                    logger.info("Initializing unmanaged monitor [" + installedMonitor.getName() + "]");
                    this.unmanagedMonitorDelegate.initializeMonitor(monitorConfigReader.getMonitorMetaData(), monitorProperties, (Map<String, String>)environmentVars.build());
                    continue;
                }
                logger.info("Initializing managed monitor [" + installedMonitor.getName() + "]");
                this.managedMonitorDelegate.initializeMonitor(monitorConfigReader.getMonitorMetaData(), monitorProperties, (Map<String, String>)environmentVars.build());
            }
            catch (InvalidMonitorConfigException e) {
                logger.warn("Could not get information for monitor " + e.getMessage(), (Throwable)e);
            }
            catch (MonitorInitializationException e) {
                logger.warn("Could not initialize monitor " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void removeMonitor(String monitorName) throws IOException {
        if (this.managedMonitorDelegate.getInstalledMonitors().contains(monitorName)) {
            this.managedMonitorDelegate.stopMonitor(monitorName, null);
            FileUtil.deleteRecursive((File)new File(this.monitorsDir + File.separator + monitorName), (ILogger)new Log4JLogger(logger));
        }
        if (this.unmanagedMonitorDelegate.getInstalledMonitors().contains(monitorName)) {
            this.unmanagedMonitorDelegate.stopMonitor(monitorName, null);
            FileUtil.deleteRecursive((File)new File(this.monitorsDir + File.separator + UNMANAGED_DIR + File.separator + monitorName), (ILogger)new Log4JLogger(logger));
        }
    }

    public void shutdown() {
        this.managedMonitorDelegate.shutdown();
    }

    public void switchDisabled(boolean isDisabled) {
        this.managedMonitorDelegate.switchDisabled(isDisabled);
        this.switchMonitorsDisabled(isDisabled);
    }

    private boolean isSimSupportedOS() {
        return SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_SOLARIS || SystemUtils.IS_OS_SUN_OS || SystemUtils.IS_OS_AIX || SystemUtils.IS_OS_HP_UX;
    }

    private Map<String, String> readMonitorPropertiesFromDisk(String monitorDir) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            MonitorPropertiesFile propsFile = new MonitorPropertiesFile(monitorDir);
            map = propsFile.getProperties();
        }
        catch (IOException e) {
            logger.debug("Could not find properties file in monitor directory [" + monitorDir + "]");
        }
        return map;
    }

    private void stopManagedMonitor(String monitorName) {
        if (this.managedMonitorDelegate.getInstalledMonitors().contains(monitorName)) {
            this.managedMonitorDelegate.stopMonitor(monitorName, null);
        }
    }

    private void stopUnmanagedMonitor(String monitorName) {
        if (this.unmanagedMonitorDelegate.getInstalledMonitors().contains(monitorName)) {
            this.unmanagedMonitorDelegate.stopMonitor(monitorName, null);
        }
    }

    private void stopAllMonitors() {
        for (String monitorName : this.managedMonitorDelegate.getInstalledMonitors()) {
            this.stopManagedMonitor(monitorName);
        }
        for (String monitorName : this.unmanagedMonitorDelegate.getInstalledMonitors()) {
            this.stopUnmanagedMonitor(monitorName);
        }
    }

    private void startAllMonitors() {
        String managedMonitorsDir = this.monitorsDir;
        this.readConfig(managedMonitorsDir, false);
        String unmanagedMonitorsDir = this.monitorsDir + File.separator + UNMANAGED_DIR;
        this.readConfig(unmanagedMonitorsDir, true);
    }

    private void switchMonitorsDisabled(boolean isDisabled) {
        logger.info("Monitors are now: [" + (isDisabled ? "disabled" : "enabled") + "].");
        if (isDisabled) {
            this.stopAllMonitors();
        } else {
            this.startAllMonitors();
        }
    }

    @Generated
    public UnmanagedMonitorDelegate getUnmanagedMonitorDelegate() {
        return this.unmanagedMonitorDelegate;
    }

    @Generated
    public ManagedMonitorDelegate getManagedMonitorDelegate() {
        return this.managedMonitorDelegate;
    }
}

