/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.monitormanager;

import com.singularity.ee.agent.commonservices.timeskewhandling.AControllerTimeSkewHandler;
import com.singularity.ee.agent.configuration.identity.AgentIdentity;
import com.singularity.ee.agent.systemagent.IMachineAgent;
import com.singularity.ee.agent.systemagent.components.AAgentComponent;
import com.singularity.ee.agent.systemagent.components.monitormanager.NodeMonitorManager;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.IMonitorOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ISystemAgentMetricSenderFactory;
import com.singularity.ee.agent.systemagent.handler.HandlerException;
import com.singularity.ee.agent.systemagent.handler.RequestHandlerContext;
import com.singularity.ee.events.MachineEventData;
import com.singularity.ee.rest.RESTResponse;
import com.singularity.ee.rest.RequestReadException;
import com.singularity.ee.rest.agent.request.MonitorDeleteRequest;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentMonitorManager
extends AAgentComponent {
    private static final Logger logger = LogManager.getLogger((String)AgentMonitorManager.class.getName());
    private static final ILogger iLogger = new Log4JLogger(logger);
    private static final String MONITOR_DIR = "monitors";
    private String monitorsDir;
    private volatile NodeMonitorManager systemMonitorManager;

    public AgentMonitorManager(String machineInstanceID, String controllerHost, int controllerPort, RequestHandlerContext handlerContext, IMachineAgent machineAgent, @NonNull Collection<IMonitorOutputHandler> additionalOutputHandlers, ISystemAgentMetricSenderFactory senderFactory) throws MalformedURLException {
        super(machineInstanceID, controllerHost, controllerPort, handlerContext);
        if (additionalOutputHandlers == null) {
            throw new NullPointerException("additionalOutputHandlers is marked non-null but is null");
        }
        this.monitorsDir = this.getInstallDir() + File.separator + MONITOR_DIR;
        IAgentScheduledExecutorService scheduler = (IAgentScheduledExecutorService)handlerContext.getAttribute("Agent-Monitor-Scheduler");
        AgentIdentity systemIdentity = (AgentIdentity)handlerContext.getAttribute("Agent-Identity");
        AControllerTimeSkewHandler skewHandler = (AControllerTimeSkewHandler)handlerContext.getAttribute("skew-handler");
        this.systemMonitorManager = new NodeMonitorManager(this.getInstallDir() + File.separator + MONITOR_DIR, systemIdentity, skewHandler, scheduler, machineAgent, additionalOutputHandlers, senderFactory);
        logger.info("Initialized System Monitor Manager with directory [" + this.monitorsDir + "]");
    }

    @Override
    public String getContextForRequests() {
        return "/agent/monitor";
    }

    public void addMachineAgentEvent(MachineEventData machineEventData) {
        this.systemMonitorManager.addMachineAgentEvent(machineEventData);
    }

    @Override
    public void handleDeleteRequest(String uri, HttpServletRequest request, HttpServletResponse response) throws HandlerException, IOException {
        String monitorName = null;
        try {
            MonitorDeleteRequest deleteRequest = new MonitorDeleteRequest(request, (ILogger)new Log4JLogger(logger));
            monitorName = deleteRequest.getMonitorName();
            String nodeName = deleteRequest.getNodeName();
            if (nodeName == null) {
                this.systemMonitorManager.removeMonitor(monitorName);
                RESTResponse.sendSuccessResponse((HttpServletResponse)response, (String)("Removed Managed Monitor [" + monitorName + "] successfully from the Agent"), (ILogger)iLogger);
            }
        }
        catch (IOException e) {
            logger.warn("Could not delete monitor directory" + e.getMessage(), (Throwable)e);
            RESTResponse.sendFailureResponse((HttpServletResponse)response, (String)"Could not delete monitor directory ", (ILogger)iLogger);
        }
        catch (RequestReadException e) {
            logger.warn("Could not remove monitor [" + monitorName + "] " + e.getMessage(), (Throwable)e);
            RESTResponse.sendFailureResponse((HttpServletResponse)response, (String)"Could not delete monitor directory ", (ILogger)iLogger);
        }
    }

    @Override
    public void handlePostRequest(String uri, HttpServletRequest request, HttpServletResponse response) throws HandlerException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleGetRequest(String uri, HttpServletRequest request, HttpServletResponse response) throws HandlerException, IOException {
        try {
            String monitorName = uri.substring(uri.lastIndexOf("/") + 1, uri.length());
            String monitorDir = this.monitorsDir + File.separator + monitorName;
            if (new File(monitorDir).exists()) {
                RESTResponse.sendSuccessResponse((HttpServletResponse)response, (String)("Found Directory for Monitor [" + monitorName + "]"), (ILogger)iLogger);
            } else {
                RESTResponse.sendSuccessResponse((HttpServletResponse)response, (String)("Could not find Directory for Monitor [" + monitorName + "]"), (ILogger)iLogger);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            RESTResponse.sendSuccessResponse((HttpServletResponse)response, (String)("Invalid URI to get Monitor [" + this.monitorsDir + "]"), (ILogger)iLogger);
        }
    }

    public NodeMonitorManager getNodeMonitorManager() {
        return this.systemMonitorManager;
    }

    @Override
    public void shutdown() {
        this.systemMonitorManager.shutdown();
    }

    @Override
    public void handlePutRequest(String uri, HttpServletRequest request, HttpServletResponse response) throws HandlerException, IOException {
        throw new HandlerException("PUT operation not supported by Agent Monitor Manager.");
    }
}

