/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.components.controlchannel.task;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.agent.systemagent.components.controlchannel.task.TaskExecutionData;
import com.singularity.ee.util.xml.XMLParseException;
import com.singularity.ee.util.xml.XMLParseUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestReader {
    private static Logger logger = LogManager.getLogger((String)RequestReader.class.getName());

    public static TaskExecutionData getTaskExecutionData(InputStream in) throws XMLParseException {
        try {
            Document xmlDoc = XMLParseUtility.getXmlDocumentFromInputStream((InputStream)in);
            logger.debug("Task Execution XML -:" + String.valueOf(xmlDoc.getDocumentElement()));
            String taskName = XMLParseUtility.getTextForTagForElement((Node)xmlDoc.getDocumentElement(), (String)"task-name");
            LinkedHashMap<String, String> taskArguments = new LinkedHashMap<String, String>();
            List argumentList = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)xmlDoc.getDocumentElement(), (String)"argument");
            for (Element argumentElement : argumentList) {
                String key = argumentElement.getAttribute("name");
                String value = argumentElement.getAttribute("value");
                taskArguments.put(key, value);
            }
            return new TaskExecutionData(taskName, taskArguments);
        }
        catch (SAXException e) {
            logger.warn("Error reading request for task execution data", (Throwable)e);
            throw new XMLParseException((Throwable)e);
        }
        catch (IOException e) {
            logger.warn("Error reading request for task execution data", (Throwable)e);
            throw new XMLParseException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.warn("Parser Configuration error", (Throwable)e);
            throw new XMLParseException((Throwable)e);
        }
    }
}

