/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.api;

import com.singularity.ee.agent.systemagent.api.AManagedMonitor;

public class MetricWriter {
    private static final String EQUALS = "=";
    private static final String METRIC_FORMAT_SEPARATOR = ",";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String AGGREGATOR_ATTRIBUTE = "aggregator";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String TIME_ROLLUP_ATTRIBUTE = "time-rollup";
    private static final String CLUSTER_ROLLUP_ATTRIBUTE = "cluster-rollup";
    public static final String METRIC_AGGREGATION_TYPE_AVERAGE = "AVERAGE";
    public static final String METRIC_AGGREGATION_TYPE_SUM = "SUM";
    public static final String METRIC_AGGREGATION_TYPE_OBSERVATION = "OBSERVATION";
    public static final String METRIC_TIME_ROLLUP_TYPE_AVERAGE = "AVERAGE";
    public static final String METRIC_TIME_ROLLUP_TYPE_SUM = "SUM";
    public static final String METRIC_TIME_ROLLUP_TYPE_CURRENT = "CURRENT";
    public static final String METRIC_CLUSTER_ROLLUP_TYPE_INDIVIDUAL = "INDIVIDUAL";
    public static final String METRIC_CLUSTER_ROLLUP_TYPE_COLLECTIVE = "COLLECTIVE";
    private final AManagedMonitor monitor;
    private final String metricName;
    private String metricAggregationType;
    private String metricTimeRollupType;
    private String metricClusterRollupType;

    MetricWriter(AManagedMonitor monitor, String name) {
        this.monitor = monitor;
        this.metricName = name;
    }

    void setMetricAggregationType(String metricAggregationType) {
        this.metricAggregationType = metricAggregationType;
    }

    void setMetricTimeRollupType(String metricTimeRollupType) {
        this.metricTimeRollupType = metricTimeRollupType;
    }

    void setMetricClusterRollupType(String metricClusterRollupType) {
        this.metricClusterRollupType = metricClusterRollupType;
    }

    public void printMetric(String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(NAME_ATTRIBUTE).append(EQUALS).append(this.metricName).append(METRIC_FORMAT_SEPARATOR);
        sb.append(VALUE_ATTRIBUTE).append(EQUALS).append(value);
        if (this.metricAggregationType != null) {
            sb.append(METRIC_FORMAT_SEPARATOR);
            sb.append(AGGREGATOR_ATTRIBUTE).append(EQUALS).append(this.metricAggregationType);
        }
        if (this.metricTimeRollupType != null) {
            sb.append(METRIC_FORMAT_SEPARATOR);
            sb.append(TIME_ROLLUP_ATTRIBUTE).append(EQUALS).append(this.metricTimeRollupType);
        }
        if (this.metricClusterRollupType != null) {
            sb.append(METRIC_FORMAT_SEPARATOR);
            sb.append(CLUSTER_ROLLUP_ATTRIBUTE).append(EQUALS).append(this.metricClusterRollupType);
        }
        this.monitor.println(sb.toString());
    }

    public static void main(String[] args) {
        MetricWriter writer = new MetricWriter(null, NAME_ATTRIBUTE);
        writer.setMetricAggregationType("AVERAGE");
        writer.setMetricClusterRollupType(METRIC_CLUSTER_ROLLUP_TYPE_INDIVIDUAL);
    }
}

