/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.api;

import com.singularity.ee.agent.systemagent.api.AJavaTask;
import com.singularity.ee.agent.systemagent.api.MetricWriter;

public abstract class AManagedMonitor
extends AJavaTask {
    @Override
    public void println(String str) {
        super.println(str);
    }

    @Override
    public void printlnErr(String str) {
        super.printlnErr(str);
    }

    public MetricWriter getMetricWriter(String metricName) {
        return new MetricWriter(this, metricName);
    }

    public MetricWriter getMetricWriter(String metricName, String metricAggregationType) throws IllegalArgumentException {
        this.validateMetricAggregation(metricAggregationType);
        MetricWriter writer = new MetricWriter(this, metricName);
        writer.setMetricAggregationType(metricAggregationType);
        return writer;
    }

    public MetricWriter getMetricWriter(String metricName, String metricAggregationType, String timeRollupType, String clusterRollupType) throws IllegalArgumentException {
        if (metricAggregationType != null) {
            this.validateMetricAggregation(metricAggregationType);
        }
        if (timeRollupType != null) {
            this.validateTimeRollup(timeRollupType);
        }
        if (clusterRollupType != null) {
            this.validateClusterRollup(clusterRollupType);
        }
        MetricWriter writer = new MetricWriter(this, metricName);
        writer.setMetricAggregationType(metricAggregationType);
        writer.setMetricTimeRollupType(timeRollupType);
        writer.setMetricClusterRollupType(clusterRollupType);
        return writer;
    }

    private void validateMetricAggregation(String metricAggregationType) {
        if (!("AVERAGE".equals(metricAggregationType) || "SUM".equals(metricAggregationType) || "OBSERVATION".equals(metricAggregationType))) {
            throw new IllegalArgumentException("Invalid Metric Aggregation Type specified, the valid types are [AVERAGE],[SUM] and [OBSERVATION]");
        }
    }

    private void validateTimeRollup(String timeRollupType) {
        if (!("AVERAGE".equals(timeRollupType) || "SUM".equals(timeRollupType) || "CURRENT".equals(timeRollupType))) {
            throw new IllegalArgumentException("Invalid Metric Time Rollup Type specified, the valid types are [AVERAGE],[SUM] and [CURRENT]");
        }
    }

    private void validateClusterRollup(String clusterRollup) {
        if (!"INDIVIDUAL".equals(clusterRollup) && !"COLLECTIVE".equals(clusterRollup)) {
            throw new IllegalArgumentException("Invalid Metric Cluster Rollup Type specified, the valid types are [COLLECTIVE]and [INDIVIDUAL]");
        }
    }
}

