/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent.api;

import com.singularity.ee.agent.systemagent.api.IOutputPropertyGatherer;
import com.singularity.ee.agent.systemagent.api.IStreamConsumer;
import com.singularity.ee.agent.systemagent.api.ITask;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AJavaTask
implements ITask {
    private volatile boolean isStopped;
    private final Collection<IStreamConsumer> outConsumers = new ConcurrentLinkedQueue<IStreamConsumer>();
    private final Collection<IStreamConsumer> errConsumers = new ConcurrentLinkedQueue<IStreamConsumer>();
    private IOutputPropertyGatherer outputPropertyGatherer;
    private ClassLoader loader;

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public IOutputPropertyGatherer getOutputPropertyGatherer() {
        return this.outputPropertyGatherer;
    }

    public void setOutputPropertyGatherer(IOutputPropertyGatherer outputPropertyGatherer) {
        this.outputPropertyGatherer = outputPropertyGatherer;
    }

    public void addErrStreamConsumer(IStreamConsumer consumer) {
        this.errConsumers.add(consumer);
    }

    public void addOutStreamConsumer(IStreamConsumer consumer) {
        this.outConsumers.add(consumer);
    }

    private void removeConsumers() {
        this.outConsumers.clear();
        this.errConsumers.clear();
    }

    public void println(String str) {
        this.checkIfStopped();
        for (IStreamConsumer consumer : this.outConsumers) {
            if (consumer.isActive()) {
                consumer.consumeLine(str);
                continue;
            }
            this.outConsumers.remove(consumer);
        }
    }

    public void printlnErr(String str) {
        this.checkIfStopped();
        for (IStreamConsumer consumer : this.errConsumers) {
            if (consumer.isActive()) {
                consumer.consumeLine(str);
                continue;
            }
            this.errConsumers.remove(consumer);
        }
    }

    private void checkIfStopped() {
        if (this.isStopped) {
            throw new RuntimeException("Task has been stopped");
        }
    }

    @Override
    public void stop() {
        this.removeConsumers();
        this.isStopped = true;
    }
}

