/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.systemagent;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentHomeDir;
import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.monitor.annotations.MonitorOutputHandlers;
import com.google.inject.Inject;
import com.singularity.ee.agent.configuration.channel.AgentConfigManager;
import com.singularity.ee.agent.systemagent.Agent;
import com.singularity.ee.agent.systemagent.ILifecycleObject;
import com.singularity.ee.agent.systemagent.SystemAgentName;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.IMonitorOutputHandler;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.ISystemAgentMetricSenderFactory;
import com.singularity.ee.agent.systemagent.config.channel.SystemAgentConfigManager;
import com.singularity.ee.agent.systemagent.runbook.localscript.RunbookHandler;
import com.singularity.ee.agent.systemagent.runbook.localscript.RunbookInitializer;
import com.singularity.ee.agent.systemagent.task.classloading.CompatClassLoading;
import com.singularity.ee.agent.util.scrub.ISensitiveDataScrubber;
import com.singularity.ee.config.IConfigurationListener;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.util.log4j.Log4JLoggerFactory;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAgent
extends Agent
implements ILifecycleObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemAgent.class);
    private volatile RunbookHandler runbookHandler;

    @Override
    @Inject
    public void setSystemAgentMetricSenderFactory(ISystemAgentMetricSenderFactory senderFactory) {
        this.senderFactory = senderFactory;
    }

    @Inject
    private SystemAgent(@MonitorOutputHandlers @NotNull Set<IMonitorOutputHandler> additionalOutputHandlers, @SystemAgentName String agentName, @AgentHomeDir String installDir, @NonNull Log4JLoggerFactory log4jLoggerFactory, @CompatClassLoading ClassLoader extensionClassLoaderParent, BootstrapConfiguration bootstrapConfiguration, ISensitiveDataScrubber sensitiveDataScrubber) {
        super(null, null, additionalOutputHandlers, installDir, agentName, log4jLoggerFactory, bootstrapConfiguration, sensitiveDataScrubber);
        if (log4jLoggerFactory == null) {
            throw new NullPointerException("log4jLoggerFactory is marked non-null but is null");
        }
    }

    public SystemAgent(@NotNull Set<IMonitorOutputHandler> additionalOutputHandlers, String agentName, String installDir, @NonNull Log4JLoggerFactory log4jLoggerFactory, BootstrapConfiguration bootstrapConfiguration, ISensitiveDataScrubber sensitiveDataScrubber) {
        this(additionalOutputHandlers, agentName, installDir, log4jLoggerFactory, null, bootstrapConfiguration, sensitiveDataScrubber);
        if (log4jLoggerFactory == null) {
            throw new NullPointerException("log4jLoggerFactory is marked non-null but is null");
        }
    }

    public void switchRunbookOperationExecutionDisabled(boolean isDisabled) {
        if (this.runbookHandler != null) {
            this.runbookHandler.switchOperationExecutionDisabled(isDisabled);
        }
    }

    @Override
    protected AgentConfigManager createConfigManager(String controllerHost, int controllerPort, String machineInstanceID, String agentID, IAgentScheduledExecutorService scheduler) {
        return new SystemAgentConfigManager(controllerHost, controllerPort, machineInstanceID, scheduler);
    }

    @Override
    protected void startServices() throws Exception {
        super.startServices();
        this.setupRunbookHandler();
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    @PreDestroy
    public void stop() {
        super.stop();
    }

    private void setupRunbookHandler() {
        boolean isServiceDisabledByDefault = this.areServicesDisabledOnStartup();
        RunbookInitializer runbookInitializer = new RunbookInitializer(this.getBootStrapInfo(), this.getControllerInfo(), this.getAgentMonitorManager(), (SystemAgentConfigManager)this.getConfigManager(), this.getInstallDir(), Boolean.getBoolean("orchestration-check-override"), isServiceDisabledByDefault);
        this.runbookHandler = (RunbookHandler)runbookInitializer.setup();
        if (this.runbookHandler != null) {
            AgentConfigManager configManager = this.getConfigManager();
            if (configManager != null) {
                configManager.registerConfigListener((IConfigurationListener)this.runbookHandler);
            } else {
                this.getLogger().warn("Failed to register runbook handler as a config listener, configManager was null");
            }
        }
    }

    @Override
    public AgentType getAgentType() {
        return AgentType.MACHINE_AGENT;
    }

    @Override
    public void switchDisabled(boolean isDisabled) {
        super.switchDisabled(isDisabled);
        this.switchRunbookOperationExecutionDisabled(isDisabled);
        this.getAgentMonitorManager().getNodeMonitorManager().switchDisabled(isDisabled);
    }

    @Override
    public void lifecycleStart() {
        this.switchDisabled(false);
    }

    @Override
    public void lifecycleStop() {
        log.debug("Stopping lifecycle");
        this.switchDisabled(true);
    }
}

