/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.nodes.xml;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.w3c.dom.Document;
import com.appdynamics.org.w3c.dom.Element;
import com.appdynamics.org.w3c.dom.Node;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.agent.nodes.ApplicationComponentNode;
import com.singularity.ee.agent.nodes.NodeMonitor;
import com.singularity.ee.agent.nodes.NodeTagNames;
import com.singularity.ee.agent.nodes.NodeType;
import com.singularity.ee.agent.systemagent.components.monitormanager.MonitorType;
import com.singularity.ee.util.xml.XMLParseUtility;
import com.singularity.ee.util.xml.XMLWriteException;
import com.singularity.ee.util.xml.XMLWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeConfigParser
implements NodeTagNames {
    private static final Logger logger = LogManager.getLogger((String)NodeConfigParser.class.getName());
    private String nodeConfigFile;

    public NodeConfigParser(String nodeConfigFile) {
        this.nodeConfigFile = nodeConfigFile;
    }

    public Map<String, ApplicationComponentNode> getConfiguredNodes() throws IOException, ParserConfigurationException, SAXException {
        System.out.println("parsing file ->" + this.nodeConfigFile);
        Document xmlDoc = XMLParseUtility.getXmlDocumentFromFile((File)new File(this.nodeConfigFile));
        System.out.println("read doc ->" + String.valueOf(xmlDoc.getDocumentElement()));
        HashMap<String, ApplicationComponentNode> nodes = new HashMap<String, ApplicationComponentNode>();
        List nodeElements = XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)xmlDoc.getDocumentElement(), (String)"node");
        for (Element nodeElement : nodeElements) {
            ApplicationComponentNode node = this.parseNode(nodeElement);
            nodes.put(node.getUniqueLocalId(), node);
        }
        return nodes;
    }

    private ApplicationComponentNode parseNode(Element nodeElement) {
        String id = XMLParseUtility.getTextForTagForElement((Node)nodeElement, (String)"node-id");
        NodeType nodeType = NodeType.valueOf(((String)XMLParseUtility.getAttributeMapForElement((Element)nodeElement).get("type")).toUpperCase());
        String localID = (String)XMLParseUtility.getAttributeMapForElement((Element)nodeElement).get("unique-local-id");
        ArrayList<NodeMonitor> nodeMonitors = new ArrayList<NodeMonitor>();
        for (Element monitorElement : XMLParseUtility.getListOfDirectSiblingsUnderWithName((Node)nodeElement, (String)"monitor")) {
            String monitorName = (String)XMLParseUtility.getAttributeMapForElement((Element)monitorElement).get("name");
            MonitorType monitorType = MonitorType.valueOf(((String)XMLParseUtility.getAttributeMapForElement((Element)monitorElement).get("type")).toUpperCase());
            String nodeIdentityFilePath = XMLParseUtility.getTextForTagForElement((Node)monitorElement, (String)"node-identity-file-path");
            NodeMonitor nodeMonitor = new NodeMonitor(monitorName, monitorType, nodeIdentityFilePath);
            nodeMonitors.add(nodeMonitor);
        }
        return new ApplicationComponentNode(id, nodeType, localID, nodeMonitors);
    }

    public static void persistConfig(String nodesConfigFile, Map<String, ApplicationComponentNode> nodes) throws IOException {
        try {
            XMLWriter writer = new XMLWriter();
            Element root = writer.getDocument().createElement("nodes");
            writer.getDocument().appendChild((Node)root);
            for (ApplicationComponentNode node : nodes.values()) {
                root.appendChild((Node)NodeConfigParser.convertToXML(node, writer));
            }
            System.out.println("SavING to FILE ------" + nodesConfigFile);
            writer.saveToFile(nodesConfigFile);
        }
        catch (ParserConfigurationException e) {
            logger.warn("Error saving Node configuration", (Throwable)e);
            throw new IOException(e.toString());
        }
        catch (XMLWriteException e) {
            logger.warn("Error saving Node configuration", e.getCause());
            throw new IOException(e.toString());
        }
    }

    public static Element convertToXML(ApplicationComponentNode node, XMLWriter writer) {
        Element nodeElement = writer.createElement("node");
        nodeElement.setAttribute("unique-local-id", node.getUniqueLocalId());
        nodeElement.setAttribute("type", node.getNodeType().name().toLowerCase());
        writer.addTextNode(nodeElement, "node-id", node.getNodeID());
        System.out.println("Node monitors in node ->" + String.valueOf(node.getNodeMonitors()));
        for (NodeMonitor nodeMonitor : node.getNodeMonitors()) {
            Element monitorNode = writer.createElement("monitor");
            monitorNode.setAttribute("name", nodeMonitor.getName());
            monitorNode.setAttribute("type", nodeMonitor.getMonitorType().name().toLowerCase());
            writer.addTextNode(monitorNode, "node-identity-file-path", nodeMonitor.getNodeIdentityFilePath());
            nodeElement.appendChild((Node)monitorNode);
        }
        return nodeElement;
    }
}

