/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.nodes;

import com.appdynamics.javax.xml.parsers.ParserConfigurationException;
import com.appdynamics.org.xml.sax.SAXException;
import com.singularity.ee.agent.configuration.identity.AgentIdentity;
import com.singularity.ee.agent.configuration.identity.XMLIdentityManager;
import com.singularity.ee.agent.configuration.impl.ConfigException;
import com.singularity.ee.agent.nodes.ApplicationComponentNode;
import com.singularity.ee.agent.nodes.NodeMonitor;
import com.singularity.ee.agent.nodes.xml.NodeConfigParser;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NodeManager {
    private static Logger logger = LogManager.getLogger((String)NodeManager.class.getName());
    public static final String NODES_CONFIG_FILE = "nodes.xml";
    private String nodesConfigFile;
    private Map<String, ApplicationComponentNode> nodes = new HashMap<String, ApplicationComponentNode>();

    public NodeManager(String agentInstallDir) throws IOException, ParserConfigurationException, SAXException {
        this.nodesConfigFile = agentInstallDir + File.separator + "nodes" + File.separator + NODES_CONFIG_FILE;
        if (new File(agentInstallDir + File.separator + "nodes").exists()) {
            System.out.println("parsing nodes config.....");
            NodeConfigParser parser = new NodeConfigParser(this.nodesConfigFile);
            this.nodes = parser.getConfiguredNodes();
        }
    }

    public Map<String, ApplicationComponentNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(Map<String, ApplicationComponentNode> nodes) {
        this.nodes = nodes;
    }

    public void saveCurrentInfo() throws IOException {
        NodeConfigParser.persistConfig(this.nodesConfigFile, this.nodes);
    }

    public void refreshNodeInfo(String uniqueLocalID, String nodeID) {
        ApplicationComponentNode node = this.nodes.get(uniqueLocalID);
        if (node != null) {
            for (NodeMonitor monitor : node.getNodeMonitors()) {
                String nodeIdentityFile = monitor.getNodeIdentityFilePath();
                XMLIdentityManager idManager = new XMLIdentityManager((ILogger)new Log4JLogger(logger));
                try {
                    AgentIdentity identity = idManager.configureInstance(new String[]{nodeIdentityFile});
                    System.out.println("saving identity -");
                    idManager.saveAgentIdentity(identity);
                }
                catch (ConfigException e) {
                    logger.error("Exception occurred while refreshing node info: {}", (Object)e.getMessage());
                }
            }
        } else {
            System.out.println("Node not found.");
        }
    }
}

