/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.validator.rules;

import com.appdynamics.agent.sim.sam.checker.HttpTargetCheckerResult;
import com.appdynamics.agent.sim.sam.validator.extractors.Extractor;
import com.appdynamics.agent.sim.sam.validator.rules.Rule;

public class StartsWithRule
implements Rule {
    private final String pattern;
    private final Extractor<String> extractor;

    public StartsWithRule(String pattern, Extractor<String> extractor) {
        this.pattern = pattern;
        this.extractor = extractor;
    }

    @Override
    public boolean validate(HttpTargetCheckerResult.ResponseResult result) {
        String body = this.extractor.extract(result);
        return body != null && body.toLowerCase().startsWith(this.pattern.toLowerCase());
    }

    @Override
    public String getFailureMessage() {
        return this.extractor.getName() + " does not start with '" + this.pattern + "'.";
    }
}

