/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.validator.rules;

import com.appdynamics.agent.sim.sam.checker.HttpTargetCheckerResult;
import com.appdynamics.agent.sim.sam.validator.extractors.Extractor;
import com.appdynamics.agent.sim.sam.validator.rules.Rule;
import java.util.regex.Pattern;

public class RegexRule
implements Rule {
    private final String patternStr;
    private final Pattern pattern;
    private final Extractor<String> extractor;

    public RegexRule(String pattern, Extractor<String> extractor) {
        this.patternStr = pattern;
        this.pattern = Pattern.compile(pattern);
        this.extractor = extractor;
    }

    @Override
    public boolean validate(HttpTargetCheckerResult.ResponseResult result) {
        String body = this.extractor.extract(result);
        return body != null && this.pattern.matcher(body).matches();
    }

    @Override
    public String getFailureMessage() {
        return this.extractor.getName() + " does not completely match the regular expression '" + this.patternStr + "'.";
    }
}

