/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.validator.rules;

import com.appdynamics.agent.sim.sam.checker.HttpTargetCheckerResult;
import com.appdynamics.agent.sim.sam.validator.RangeRuleData;
import com.appdynamics.agent.sim.sam.validator.extractors.Extractor;
import com.appdynamics.agent.sim.sam.validator.rules.Rule;
import com.appdynamics.sim.common.rest.sam.SamRuleOperatorDto;
import com.google.common.annotations.VisibleForTesting;
import lombok.NonNull;

public class RangeRule<T extends Comparable<? super T>>
implements Rule {
    private static final String IS_GREATER_THAN = " is greater than ";
    private static final String IS_LESS_THAN = " is less than ";
    private static final String IS_NOT_EQUAL_TO = " is not equal to ";
    private static final String OR_EQUAL_TO = "or equal to ";
    private final T minVal;
    private final T maxVal;
    private final boolean inclusive;
    private final Extractor<? extends T> extractor;
    private final SamRuleOperatorDto operator;

    public RangeRule(@NonNull T minVal, @NonNull T maxVal, boolean inclusive, Extractor<T> extractor, SamRuleOperatorDto operator) {
        if (minVal == null) {
            throw new NullPointerException("minVal is marked non-null but is null");
        }
        if (maxVal == null) {
            throw new NullPointerException("maxVal is marked non-null but is null");
        }
        if (minVal.compareTo(maxVal) > 0) {
            throw new IllegalArgumentException("Service Availability Monitor: Cannot create RangeValidator, illogical range.");
        }
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.inclusive = inclusive;
        this.extractor = extractor;
        this.operator = operator;
    }

    public RangeRule(RangeRuleData<T> rangeRuleData, Extractor<T> extractor) {
        this.minVal = (Comparable)rangeRuleData.getMinValue();
        this.maxVal = (Comparable)rangeRuleData.getMaxValue();
        this.inclusive = rangeRuleData.isInclusive();
        this.extractor = extractor;
        this.operator = rangeRuleData.getOperator();
    }

    @Override
    public boolean validate(HttpTargetCheckerResult.ResponseResult result) {
        Comparable value = (Comparable)this.extractor.extract(result);
        if (value == null) {
            return false;
        }
        boolean resultCheck = false;
        if (this.inclusive) {
            if (value.compareTo(this.maxVal) <= 0 && value.compareTo(this.minVal) >= 0) {
                resultCheck = true;
            }
        } else if (value.compareTo(this.maxVal) < 0 && value.compareTo(this.minVal) > 0) {
            resultCheck = true;
        }
        return resultCheck;
    }

    @Override
    public String getFailureMessage() {
        StringBuilder failureMessage = new StringBuilder(this.extractor.getName());
        failureMessage.append(this.constructFailureMessage(this.operator, this.minVal, this.maxVal));
        return failureMessage.toString();
    }

    @VisibleForTesting
    String constructFailureMessage(SamRuleOperatorDto operatorDto, T minVal, T maxVal) {
        T val;
        StringBuilder messageBuilder = new StringBuilder();
        switch (operatorDto) {
            case GREATER_THAN: {
                messageBuilder.append(IS_LESS_THAN).append(OR_EQUAL_TO);
                val = minVal;
                break;
            }
            case GREATER_THAN_EQ: {
                messageBuilder.append(IS_LESS_THAN);
                val = minVal;
                break;
            }
            case LESS_THAN: {
                messageBuilder.append(IS_GREATER_THAN).append(OR_EQUAL_TO);
                val = maxVal;
                break;
            }
            case LESS_THAN_EQ: {
                messageBuilder.append(IS_GREATER_THAN);
                val = maxVal;
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: {
                messageBuilder.append(IS_NOT_EQUAL_TO);
                val = minVal;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized operator " + operatorDto.name() + " for constructing failure message");
            }
        }
        messageBuilder.append(val).append(".");
        return messageBuilder.toString();
    }
}

