/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.validator.factory;

import com.appdynamics.agent.sim.sam.validator.RangeRuleData;
import com.appdynamics.agent.sim.sam.validator.extractors.Extractor;
import com.appdynamics.agent.sim.sam.validator.factory.RuleFactory;
import com.appdynamics.agent.sim.sam.validator.rules.RangeRule;
import com.appdynamics.agent.sim.sam.validator.rules.Rule;
import com.appdynamics.sim.common.rest.sam.SamRuleFieldDto;
import com.appdynamics.sim.common.rest.sam.SamRuleOperatorDto;
import com.appdynamics.sim.common.rest.sam.SamValidationRuleDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeRuleFactory
implements RuleFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RangeRuleFactory.class);
    private final Map<SamRuleFieldDto, Extractor<Integer>> intExtractorMap;
    private final Map<SamRuleFieldDto, Extractor<Long>> longExtractorMap;

    @Inject
    RangeRuleFactory(Map<SamRuleFieldDto, Extractor<Integer>> intExtractorMap, Map<SamRuleFieldDto, Extractor<Long>> longExtractorMap) {
        this.intExtractorMap = intExtractorMap;
        this.longExtractorMap = longExtractorMap;
    }

    @Override
    public Rule create(SamValidationRuleDto validationRuleDto) {
        String value = validationRuleDto.getValue();
        Extractor<Integer> integerExtractor = this.intExtractorMap.get(validationRuleDto.getField());
        if (integerExtractor != null) {
            RangeRuleData<Integer> rangeRuleData = this.createByOperator(validationRuleDto.getOperator(), Integer.valueOf(validationRuleDto.getValue()), Integer.MIN_VALUE, Integer.MAX_VALUE);
            return new RangeRule<Integer>(rangeRuleData, integerExtractor);
        }
        Extractor<Long> longExtractor = this.longExtractorMap.get(validationRuleDto.getField());
        if (longExtractor != null) {
            RangeRuleData<Long> rangeRuleData = this.createByOperator(validationRuleDto.getOperator(), Long.valueOf(validationRuleDto.getValue()), Long.MIN_VALUE, Long.MAX_VALUE);
            return new RangeRule<Long>(rangeRuleData, longExtractor);
        }
        throw new UnsupportedOperationException("The Validation Rule Value class type is not supported. Class: " + String.valueOf(value.getClass()));
    }

    @VisibleForTesting
    <T> RangeRuleData<T> createByOperator(SamRuleOperatorDto operator, T value, T minBound, T maxBound) {
        switch (operator) {
            case LESS_THAN_EQ: {
                return new RangeRuleData<T>(minBound, value, true, operator);
            }
            case LESS_THAN: {
                return new RangeRuleData<T>(minBound, value, false, operator);
            }
            case GREATER_THAN_EQ: {
                return new RangeRuleData<T>(value, maxBound, true, operator);
            }
            case GREATER_THAN: {
                return new RangeRuleData<T>(value, maxBound, false, operator);
            }
        }
        throw new IllegalStateException("Unrecognized operator " + operator.name() + " for creating numeric range rule");
    }
}

