/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.validator.factory;

import com.appdynamics.agent.sim.sam.validator.extractors.Extractor;
import com.appdynamics.agent.sim.sam.validator.factory.RuleFactory;
import com.appdynamics.agent.sim.sam.validator.rules.RangeRule;
import com.appdynamics.agent.sim.sam.validator.rules.Rule;
import com.appdynamics.sim.common.rest.sam.SamRuleFieldDto;
import com.appdynamics.sim.common.rest.sam.SamRuleOperatorDto;
import com.appdynamics.sim.common.rest.sam.SamValidationRuleDto;
import com.google.inject.Inject;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqualsRuleFactory
implements RuleFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EqualsRuleFactory.class);
    private final Map<SamRuleFieldDto, Extractor<Integer>> intExtractorMap;
    private final Map<SamRuleFieldDto, Extractor<String>> stringExtractorMap;
    private final Map<SamRuleFieldDto, Extractor<Long>> longExtractorMap;

    @Inject
    EqualsRuleFactory(Map<SamRuleFieldDto, Extractor<Integer>> intExtractorMap, Map<SamRuleFieldDto, Extractor<String>> stringExtractorMap, Map<SamRuleFieldDto, Extractor<Long>> longExtractorMap) {
        this.intExtractorMap = intExtractorMap;
        this.stringExtractorMap = stringExtractorMap;
        this.longExtractorMap = longExtractorMap;
    }

    @Override
    public Rule create(SamValidationRuleDto validationRuleDto) {
        String value = validationRuleDto.getValue();
        SamRuleOperatorDto operator = validationRuleDto.getOperator();
        Extractor<String> stringExtractor = this.stringExtractorMap.get(validationRuleDto.getField());
        if (stringExtractor != null) {
            return new RangeRule<String>(value.toLowerCase(), value.toLowerCase(), true, stringExtractor, operator);
        }
        Extractor<Integer> integerExtractor = this.intExtractorMap.get(validationRuleDto.getField());
        if (integerExtractor != null) {
            return new RangeRule<Integer>(Integer.valueOf(value), Integer.valueOf(value), true, integerExtractor, operator);
        }
        Extractor<Long> longExtractor = this.longExtractorMap.get(validationRuleDto.getField());
        if (longExtractor != null) {
            return new RangeRule<Long>(Long.valueOf(value), Long.valueOf(value), true, longExtractor, operator);
        }
        throw new UnsupportedOperationException("The Validation Rule Value class type is not supported. Class: " + String.valueOf(value.getClass()));
    }
}

