/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.checker;

import com.appdynamics.agent.sim.sam.SamEventService;
import com.appdynamics.agent.sim.sam.StateService;
import com.appdynamics.agent.sim.sam.checker.EvictingQueueFactory;
import com.appdynamics.agent.sim.sam.checker.HttpTargetChecker;
import com.appdynamics.agent.sim.sam.checker.HttpTargetCheckerResult;
import com.appdynamics.agent.sim.sam.checker.SamEventData;
import com.appdynamics.agent.sim.sam.checker.SamEventDataFactory;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.common.rest.constants.SimMetricsConstants;
import com.appdynamics.sim.common.rest.sam.SamTargetHttpFullDto;
import com.appdynamics.sim.common.rest.sam.SamTargetStateDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTargetCheckerTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpTargetCheckerTask.class);
    private static final int ONE_HUNDRED_PERCENT = 100;
    private static final int ZERO_PERCENT = 0;
    private final SamTargetHttpFullDto samTarget;
    private final Scheduler scheduler;
    private final EvictingQueueFactory evictingQueueFactory;
    private final HttpTargetChecker checker;
    private final MetricsService metricsService;
    private final SamEventService eventsService;
    private final StateService stateService;
    private final SamEventDataFactory eventDatafactory;
    private final String requestString;
    private final EvictingQueue<HttpTargetCheckerResult> history;
    private volatile SamTargetStateDto currentState;
    private volatile ScheduledFuture<?> future;
    private volatile SamEventData latestEventData;

    @Inject
    HttpTargetCheckerTask(@Assisted SamTargetHttpFullDto samTarget, Scheduler scheduler, HttpTargetChecker.Factory checkerFactory, MetricsService metricsService, SamEventService eventsService, EvictingQueueFactory evictingQueueFactory, StateService stateService, SamEventDataFactory eventDataFactory) {
        this.samTarget = samTarget;
        this.scheduler = scheduler;
        this.evictingQueueFactory = evictingQueueFactory;
        this.checker = checkerFactory.create(samTarget.getConfig());
        this.metricsService = metricsService;
        this.eventsService = eventsService;
        this.history = evictingQueueFactory.make(samTarget.getConfig().getThresholdWindow());
        this.requestString = samTarget.getConfig().getRequestString();
        this.currentState = samTarget.getState();
        this.stateService = stateService;
        this.eventDatafactory = eventDataFactory;
    }

    public void startCheckService() {
        if (this.future == null) {
            long pingInterval = this.samTarget.getConfig().getPingIntervalSeconds();
            this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, pingInterval, pingInterval, TimeUnit.SECONDS);
        }
    }

    public void stopCheckService() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    @Override
    public void run() {
        try {
            log.debug("Starting check for service '{}' with id: {}", (Object)this.samTarget.getName(), (Object)this.samTarget.getId());
            HttpTargetCheckerResult result = this.checker.checkResource();
            log.debug("Got result for service '{}' with id: {}!", (Object)this.samTarget.getName(), (Object)this.samTarget.getId());
            this.history.add((Object)result);
            boolean isStateChanged = this.evaluateServiceHealthState();
            this.latestEventData = this.eventDatafactory.create(result, this.samTarget, this.currentState, this.requestString);
            if (isStateChanged) {
                this.eventsService.sendEvent(this.latestEventData);
                this.stateService.sendNow();
            }
            this.sendMetrics(result);
        }
        catch (Exception e) {
            log.warn("Failed to run check for " + this.samTarget.getName(), (Throwable)e);
        }
    }

    @VisibleForTesting
    boolean evaluateServiceHealthState() {
        if (this.history.size() == this.samTarget.getConfig().getThresholdWindow()) {
            boolean hasChanged;
            SamTargetStateDto prevState = this.currentState;
            int numSuccesses = 0;
            int numFailures = 0;
            for (HttpTargetCheckerResult result : this.history) {
                if (result.isServiceHealthy()) {
                    ++numSuccesses;
                    continue;
                }
                ++numFailures;
            }
            if (numFailures >= this.samTarget.getConfig().getFailureThreshold()) {
                this.currentState = SamTargetStateDto.CRITICAL;
            } else if (numSuccesses >= this.samTarget.getConfig().getSuccessThreshold()) {
                this.currentState = SamTargetStateDto.NORMAL;
            }
            boolean bl = hasChanged = prevState != this.currentState;
            if (hasChanged) {
                log.debug("SAM state of service {} has changed from {} to {}", new Object[]{this.samTarget.getName(), prevState, this.currentState});
            }
            return hasChanged;
        }
        return false;
    }

    @VisibleForTesting
    void sendMetrics(HttpTargetCheckerResult result) {
        long successValue = result.isServiceHealthy() ? 100L : 0L;
        try {
            this.metricsService.reportMetric(SimMetricsConstants.format((String)"Hardware Resources|Service Availability|{0}|Success Rate (%)", (Object)this.samTarget.getId()), ExtensionMetricAggregatorType.AVERAGE, successValue);
        }
        catch (Exception e) {
            log.warn("Failed to report success rate for target " + this.samTarget.getName(), (Throwable)e);
        }
        if (result.getResponseResult().isPresent()) {
            HttpTargetCheckerResult.ResponseResult responseResult = (HttpTargetCheckerResult.ResponseResult)result.getResponseResult().get();
            try {
                this.metricsService.reportMetric(SimMetricsConstants.format((String)"Hardware Resources|Service Availability|{0}|Response Time (ms)", (Object)this.samTarget.getId()), ExtensionMetricAggregatorType.AVERAGE, responseResult.getResponseTime());
            }
            catch (Exception e) {
                log.warn("Failed to report response time for target " + this.samTarget.getName(), (Throwable)e);
            }
            try {
                this.metricsService.reportMetric(SimMetricsConstants.format((String)"Hardware Resources|Service Availability|{0}|Response Size (bytes)", (Object)this.samTarget.getId()), ExtensionMetricAggregatorType.AVERAGE, (long)responseResult.getResponseSize());
            }
            catch (Exception e) {
                log.warn("Failed to report response size for target " + this.samTarget.getName(), (Throwable)e);
            }
        }
    }

    public long getId() {
        return this.samTarget.getId();
    }

    @Generated
    public String toString() {
        return "HttpTargetCheckerTask(samTarget=" + String.valueOf(this.samTarget) + ", scheduler=" + String.valueOf(this.scheduler) + ", evictingQueueFactory=" + String.valueOf(this.evictingQueueFactory) + ", checker=" + String.valueOf(this.checker) + ", metricsService=" + String.valueOf(this.metricsService) + ", eventsService=" + String.valueOf(this.eventsService) + ", stateService=" + String.valueOf(this.stateService) + ", eventDatafactory=" + String.valueOf(this.eventDatafactory) + ", requestString=" + this.getRequestString() + ", history=" + String.valueOf(this.getHistory()) + ", currentState=" + String.valueOf(this.getCurrentState()) + ", future=" + String.valueOf(this.future) + ", latestEventData=" + String.valueOf(this.getLatestEventData()) + ")";
    }

    @Generated
    public String getRequestString() {
        return this.requestString;
    }

    @Generated
    public EvictingQueue<HttpTargetCheckerResult> getHistory() {
        return this.history;
    }

    @Generated
    public SamTargetStateDto getCurrentState() {
        return this.currentState;
    }

    @Generated
    void setCurrentState(SamTargetStateDto currentState) {
        this.currentState = currentState;
    }

    @Generated
    public SamEventData getLatestEventData() {
        return this.latestEventData;
    }

    public static interface Factory {
        public HttpTargetCheckerTask makeCheckerTask(SamTargetHttpFullDto var1);
    }
}

