/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.checker;

import com.appdynamics.sim.common.rest.sam.HttpHeaderDto;
import com.google.common.base.Optional;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public class HttpTargetCheckerResult {
    @NonNull
    private final Optional<ResponseResult> responseResult;
    @NonNull
    private final ValidationResult validationResult;

    public boolean isServiceHealthy() {
        return this.responseResult.isPresent() && this.validationResult.isSuccessful();
    }

    @NonNull
    @Generated
    public Optional<ResponseResult> getResponseResult() {
        return this.responseResult;
    }

    @NonNull
    @Generated
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpTargetCheckerResult)) {
            return false;
        }
        HttpTargetCheckerResult other = (HttpTargetCheckerResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<ResponseResult> this$responseResult = this.getResponseResult();
        Optional<ResponseResult> other$responseResult = other.getResponseResult();
        if (this$responseResult == null ? other$responseResult != null : !this$responseResult.equals(other$responseResult)) {
            return false;
        }
        ValidationResult this$validationResult = this.getValidationResult();
        ValidationResult other$validationResult = other.getValidationResult();
        return !(this$validationResult == null ? other$validationResult != null : !((Object)this$validationResult).equals(other$validationResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpTargetCheckerResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<ResponseResult> $responseResult = this.getResponseResult();
        result = result * 59 + ($responseResult == null ? 43 : $responseResult.hashCode());
        ValidationResult $validationResult = this.getValidationResult();
        result = result * 59 + ($validationResult == null ? 43 : ((Object)$validationResult).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpTargetCheckerResult(responseResult=" + String.valueOf(this.getResponseResult()) + ", validationResult=" + String.valueOf(this.getValidationResult()) + ")";
    }

    @Generated
    public HttpTargetCheckerResult(@NonNull Optional<ResponseResult> responseResult, @NonNull ValidationResult validationResult) {
        if (responseResult == null) {
            throw new NullPointerException("responseResult is marked non-null but is null");
        }
        if (validationResult == null) {
            throw new NullPointerException("validationResult is marked non-null but is null");
        }
        this.responseResult = responseResult;
        this.validationResult = validationResult;
    }

    public static class ValidationResult {
        private final boolean successful;
        @NonNull
        private final String validationMessage;

        @Generated
        public static ValidationResultBuilder builder() {
            return new ValidationResultBuilder();
        }

        @Generated
        public boolean isSuccessful() {
            return this.successful;
        }

        @NonNull
        @Generated
        public String getValidationMessage() {
            return this.validationMessage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidationResult)) {
                return false;
            }
            ValidationResult other = (ValidationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccessful() != other.isSuccessful()) {
                return false;
            }
            String this$validationMessage = this.getValidationMessage();
            String other$validationMessage = other.getValidationMessage();
            return !(this$validationMessage == null ? other$validationMessage != null : !this$validationMessage.equals(other$validationMessage));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ValidationResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccessful() ? 79 : 97);
            String $validationMessage = this.getValidationMessage();
            result = result * 59 + ($validationMessage == null ? 43 : $validationMessage.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HttpTargetCheckerResult.ValidationResult(successful=" + this.isSuccessful() + ", validationMessage=" + this.getValidationMessage() + ")";
        }

        @Generated
        public ValidationResult(boolean successful, @NonNull String validationMessage) {
            if (validationMessage == null) {
                throw new NullPointerException("validationMessage is marked non-null but is null");
            }
            this.successful = successful;
            this.validationMessage = validationMessage;
        }

        @Generated
        public static class ValidationResultBuilder {
            @Generated
            private boolean successful;
            @Generated
            private String validationMessage;

            @Generated
            ValidationResultBuilder() {
            }

            @Generated
            public ValidationResultBuilder successful(boolean successful) {
                this.successful = successful;
                return this;
            }

            @Generated
            public ValidationResultBuilder validationMessage(@NonNull String validationMessage) {
                if (validationMessage == null) {
                    throw new NullPointerException("validationMessage is marked non-null but is null");
                }
                this.validationMessage = validationMessage;
                return this;
            }

            @Generated
            public ValidationResult build() {
                return new ValidationResult(this.successful, this.validationMessage);
            }

            @Generated
            public String toString() {
                return "HttpTargetCheckerResult.ValidationResult.ValidationResultBuilder(successful=" + this.successful + ", validationMessage=" + this.validationMessage + ")";
            }
        }
    }

    public static class ResponseResult {
        private final int statusCode;
        @NonNull
        private final String responseReasonPhrase;
        private final long responseTime;
        private final int responseSize;
        @NonNull
        private final List<HttpHeaderDto> responseHeaders;
        private final Optional<String> responseBody;

        public String getFullResponse() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.statusCode).append(" ").append(this.responseReasonPhrase).append("\n\n");
            for (HttpHeaderDto header : this.responseHeaders) {
                sb.append(header.toHeaderString()).append("\n");
            }
            sb.append("\n");
            sb.append((String)this.responseBody.or((Object)""));
            return sb.toString();
        }

        @Generated
        public static ResponseResultBuilder builder() {
            return new ResponseResultBuilder();
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @NonNull
        @Generated
        public String getResponseReasonPhrase() {
            return this.responseReasonPhrase;
        }

        @Generated
        public long getResponseTime() {
            return this.responseTime;
        }

        @Generated
        public int getResponseSize() {
            return this.responseSize;
        }

        @NonNull
        @Generated
        public List<HttpHeaderDto> getResponseHeaders() {
            return this.responseHeaders;
        }

        @Generated
        public Optional<String> getResponseBody() {
            return this.responseBody;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseResult)) {
                return false;
            }
            ResponseResult other = (ResponseResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatusCode() != other.getStatusCode()) {
                return false;
            }
            if (this.getResponseTime() != other.getResponseTime()) {
                return false;
            }
            if (this.getResponseSize() != other.getResponseSize()) {
                return false;
            }
            String this$responseReasonPhrase = this.getResponseReasonPhrase();
            String other$responseReasonPhrase = other.getResponseReasonPhrase();
            if (this$responseReasonPhrase == null ? other$responseReasonPhrase != null : !this$responseReasonPhrase.equals(other$responseReasonPhrase)) {
                return false;
            }
            List<HttpHeaderDto> this$responseHeaders = this.getResponseHeaders();
            List<HttpHeaderDto> other$responseHeaders = other.getResponseHeaders();
            if (this$responseHeaders == null ? other$responseHeaders != null : !((Object)this$responseHeaders).equals(other$responseHeaders)) {
                return false;
            }
            Optional<String> this$responseBody = this.getResponseBody();
            Optional<String> other$responseBody = other.getResponseBody();
            return !(this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResponseResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatusCode();
            long $responseTime = this.getResponseTime();
            result = result * 59 + (int)($responseTime >>> 32 ^ $responseTime);
            result = result * 59 + this.getResponseSize();
            String $responseReasonPhrase = this.getResponseReasonPhrase();
            result = result * 59 + ($responseReasonPhrase == null ? 43 : $responseReasonPhrase.hashCode());
            List<HttpHeaderDto> $responseHeaders = this.getResponseHeaders();
            result = result * 59 + ($responseHeaders == null ? 43 : ((Object)$responseHeaders).hashCode());
            Optional<String> $responseBody = this.getResponseBody();
            result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HttpTargetCheckerResult.ResponseResult(statusCode=" + this.getStatusCode() + ", responseReasonPhrase=" + this.getResponseReasonPhrase() + ", responseTime=" + this.getResponseTime() + ", responseSize=" + this.getResponseSize() + ", responseHeaders=" + String.valueOf(this.getResponseHeaders()) + ", responseBody=" + String.valueOf(this.getResponseBody()) + ")";
        }

        @Generated
        public ResponseResult(int statusCode, @NonNull String responseReasonPhrase, long responseTime, int responseSize, @NonNull List<HttpHeaderDto> responseHeaders, Optional<String> responseBody) {
            if (responseReasonPhrase == null) {
                throw new NullPointerException("responseReasonPhrase is marked non-null but is null");
            }
            if (responseHeaders == null) {
                throw new NullPointerException("responseHeaders is marked non-null but is null");
            }
            this.statusCode = statusCode;
            this.responseReasonPhrase = responseReasonPhrase;
            this.responseTime = responseTime;
            this.responseSize = responseSize;
            this.responseHeaders = responseHeaders;
            this.responseBody = responseBody;
        }

        @Generated
        public static class ResponseResultBuilder {
            @Generated
            private int statusCode;
            @Generated
            private String responseReasonPhrase;
            @Generated
            private long responseTime;
            @Generated
            private int responseSize;
            @Generated
            private List<HttpHeaderDto> responseHeaders;
            @Generated
            private Optional<String> responseBody;

            @Generated
            ResponseResultBuilder() {
            }

            @Generated
            public ResponseResultBuilder statusCode(int statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            @Generated
            public ResponseResultBuilder responseReasonPhrase(@NonNull String responseReasonPhrase) {
                if (responseReasonPhrase == null) {
                    throw new NullPointerException("responseReasonPhrase is marked non-null but is null");
                }
                this.responseReasonPhrase = responseReasonPhrase;
                return this;
            }

            @Generated
            public ResponseResultBuilder responseTime(long responseTime) {
                this.responseTime = responseTime;
                return this;
            }

            @Generated
            public ResponseResultBuilder responseSize(int responseSize) {
                this.responseSize = responseSize;
                return this;
            }

            @Generated
            public ResponseResultBuilder responseHeaders(@NonNull List<HttpHeaderDto> responseHeaders) {
                if (responseHeaders == null) {
                    throw new NullPointerException("responseHeaders is marked non-null but is null");
                }
                this.responseHeaders = responseHeaders;
                return this;
            }

            @Generated
            public ResponseResultBuilder responseBody(Optional<String> responseBody) {
                this.responseBody = responseBody;
                return this;
            }

            @Generated
            public ResponseResult build() {
                return new ResponseResult(this.statusCode, this.responseReasonPhrase, this.responseTime, this.responseSize, this.responseHeaders, this.responseBody);
            }

            @Generated
            public String toString() {
                return "HttpTargetCheckerResult.ResponseResult.ResponseResultBuilder(statusCode=" + this.statusCode + ", responseReasonPhrase=" + this.responseReasonPhrase + ", responseTime=" + this.responseTime + ", responseSize=" + this.responseSize + ", responseHeaders=" + String.valueOf(this.responseHeaders) + ", responseBody=" + String.valueOf(this.responseBody) + ")";
            }
        }
    }
}

