/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.checker;

import com.appdynamics.agent.sim.sam.SamExtension;
import com.appdynamics.agent.sim.sam.checker.HttpTargetCheckerResult;
import com.appdynamics.agent.sim.sam.validator.RuleChainFactory;
import com.appdynamics.agent.sim.sam.validator.rules.Rule;
import com.appdynamics.agent.sim.time.DefaultTicker;
import com.appdynamics.sim.common.rest.sam.HttpHeaderDto;
import com.appdynamics.sim.common.rest.sam.SamTargetHttpConfigDto;
import com.appdynamics.sim.common.rest.sam.SamTargetHttpMethodDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Ticker;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTargetChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpTargetChecker.class);
    private final CloseableHttpClient client;
    private final Ticker ticker;
    private final List<Rule> ruleChain;
    private final HttpUriRequest httpUriRequest;
    private final SamTargetHttpConfigDto config;

    @Inject
    @VisibleForTesting
    HttpTargetChecker(@SamExtension CloseableHttpClient client, RuleChainFactory ruleChainFactory, @DefaultTicker Ticker ticker, @Assisted SamTargetHttpConfigDto config) {
        this.client = client;
        this.ticker = ticker;
        this.ruleChain = ruleChainFactory.makeRulesFrom(config.getValidationRules());
        this.httpUriRequest = this.buildRequest(config);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpTargetCheckerResult checkResource() {
        Optional responseResultOpt;
        HttpTargetCheckerResult.ValidationResult validationResult;
        HttpTargetCheckerResult.ResponseResult.ResponseResultBuilder responseResultBuilder = HttpTargetCheckerResult.ResponseResult.builder();
        try {
            URL url = new URL(this.httpUriRequest.getURI().toString());
            HttpTargetChecker.checkForRedirectsToRestrictedAddress(url);
            long startTime = this.ticker.read();
            CloseableHttpResponse resp = this.client.execute(this.httpUriRequest);
            try {
                long endTime = this.ticker.read();
                responseResultBuilder.responseTime(TimeUnit.NANOSECONDS.toMillis(endTime - startTime));
                this.populateResponseResult(responseResultBuilder, resp);
                HttpTargetCheckerResult.ResponseResult responseResult = responseResultBuilder.build();
                validationResult = HttpTargetChecker.validateResult(this.ruleChain, responseResult);
                responseResultOpt = Optional.of((Object)responseResult);
            }
            finally {
                if (Collections.singletonList(resp).get(0) != null) {
                    resp.close();
                }
            }
        }
        catch (Exception e) {
            log.debug("Failed to execute request to " + this.config.getTarget(), (Throwable)e);
            responseResultOpt = Optional.absent();
            validationResult = HttpTargetCheckerResult.ValidationResult.builder().successful(false).validationMessage("Failed to execute request: " + e.getMessage()).build();
        }
        return new HttpTargetCheckerResult((Optional<HttpTargetCheckerResult.ResponseResult>)responseResultOpt, validationResult);
    }

    private void populateResponseResult(HttpTargetCheckerResult.ResponseResult.ResponseResultBuilder result, CloseableHttpResponse resp) throws IOException {
        int statusCode = resp.getStatusLine().getStatusCode();
        result.statusCode(statusCode);
        result.responseReasonPhrase(resp.getStatusLine().getReasonPhrase());
        Optional<String> responseContent = this.readResponseContent(resp);
        result.responseBody(responseContent);
        int responseSize = 0;
        if (responseContent.isPresent()) {
            responseSize = ((String)responseContent.get()).length();
        }
        result.responseSize(responseSize);
        Header[] foundHeaders = resp.getAllHeaders();
        ArrayList<HttpHeaderDto> responseHeaders = new ArrayList<HttpHeaderDto>(foundHeaders.length);
        for (Header foundHeader : foundHeaders) {
            responseHeaders.add(new HttpHeaderDto(foundHeader.getName(), foundHeader.getValue()));
        }
        result.responseHeaders(responseHeaders);
    }

    private Optional<String> readResponseContent(CloseableHttpResponse resp) {
        HttpEntity entity = resp.getEntity();
        String content = null;
        if (entity != null) {
            try {
                BoundedInputStream input = new BoundedInputStream(entity.getContent(), (long)this.config.getDownloadSize());
                content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.warn("Could not read response for target " + this.config.getTarget() + ".", (Throwable)e);
            }
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException e) {
                log.warn("Could not clean resources after reading response for target " + this.config.getTarget() + ".", (Throwable)e);
            }
        }
        return Optional.fromNullable(content);
    }

    private HttpUriRequest buildRequest(SamTargetHttpConfigDto config) {
        HttpGet request;
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(config.getConnectTimeoutMillis()).setSocketTimeout(config.getSocketTimeoutMillis()).setRedirectsEnabled(config.isFollowRedirects());
        RequestConfig reqConfig = builder.build();
        SamTargetHttpMethodDto method = config.getMethod();
        switch (method) {
            case GET: {
                request = new HttpGet(config.getTarget());
                break;
            }
            case POST: {
                HttpPost post = new HttpPost(config.getTarget());
                if (config.getBody() != null) {
                    post.setEntity((HttpEntity)new StringEntity(config.getBody(), Charsets.UTF_8));
                }
                request = post;
                break;
            }
            case HEAD: {
                request = new HttpHead(config.getTarget());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Http method " + String.valueOf(method));
            }
        }
        request.setConfig(reqConfig);
        for (HttpHeaderDto header : config.getHeaders()) {
            request.addHeader(header.getName(), header.getValue());
        }
        return request;
    }

    @VisibleForTesting
    static HttpTargetCheckerResult.ValidationResult validateResult(List<Rule> ruleChain, @NonNull HttpTargetCheckerResult.ResponseResult responseResult) {
        if (responseResult == null) {
            throw new NullPointerException("responseResult is marked non-null but is null");
        }
        HttpTargetCheckerResult.ValidationResult.ValidationResultBuilder resultBuilder = HttpTargetCheckerResult.ValidationResult.builder();
        resultBuilder.successful(true).validationMessage("All checks passed.");
        for (Rule rule : ruleChain) {
            if (rule.validate(responseResult)) continue;
            resultBuilder.successful(false);
            resultBuilder.validationMessage("Failed to validate: " + rule.getFailureMessage());
            break;
        }
        return resultBuilder.build();
    }

    @VisibleForTesting
    static void checkForRedirectsToRestrictedAddress(URL url) throws IOException, RestrictedAddressException {
        String location = null;
        if (url.getProtocol().equals("https")) {
            log.debug("The redirect originated from a https site. We assume the proper certificates are in place to prevent users from using a secure site to access restricted addresses");
        } else {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setInstanceFollowRedirects(false);
            con.connect();
            location = con.getHeaderField("Location");
        }
        if (location != null) {
            URL redirectedUrl = new URL(location);
            String host = redirectedUrl.getHost();
            InetAddress targetInetAddress = InetAddress.getByName(host);
            if (targetInetAddress.isLoopbackAddress()) {
                throw new RestrictedAddressException("Target URL Redirects to a loopback address");
            }
            if (targetInetAddress.isSiteLocalAddress()) {
                throw new RestrictedAddressException("Target URL Redirects to a site local address");
            }
            if (targetInetAddress.isLinkLocalAddress()) {
                throw new RestrictedAddressException("Target URL Redirects to a link local address");
            }
            if (targetInetAddress.isAnyLocalAddress()) {
                throw new RestrictedAddressException("Target URL Redirects to an any local address");
            }
            if (targetInetAddress.isMulticastAddress()) {
                throw new RestrictedAddressException("Target URL Redirects to a multicast address");
            }
        }
    }

    static class RestrictedAddressException
    extends Exception {
        public RestrictedAddressException(String msg) {
            super(msg);
        }
    }

    public static interface Factory {
        public HttpTargetChecker create(SamTargetHttpConfigDto var1);
    }
}

