/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam.checker;

import com.appdynamics.agent.sim.sam.SamExtension;
import com.appdynamics.agent.sim.sam.checker.EvictingQueueFactory;
import com.appdynamics.agent.sim.sam.checker.HttpTargetChecker;
import com.appdynamics.agent.sim.sam.checker.HttpTargetCheckerTask;
import com.appdynamics.agent.sim.sam.checker.SamEventDataFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import lombok.Generated;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckerModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckerModule.class);

    protected void configure() {
        this.install(new FactoryModuleBuilder().build(HttpTargetCheckerTask.Factory.class));
        this.install(new FactoryModuleBuilder().build(HttpTargetChecker.Factory.class));
        this.bind(SamEventDataFactory.class);
        this.bind(EvictingQueueFactory.class);
    }

    @Provides
    @Singleton
    @SamExtension
    @VisibleForTesting
    CloseableHttpClient provideHttpClient() {
        try {
            HttpClientBuilder httpClientBuilder = this.getHttpClientBuilder();
            this.setConnectionReuse(httpClientBuilder);
            this.setSSLConnectionSocketFactory(httpClientBuilder);
            return httpClientBuilder.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.warn("Failed to load SSL. Using default client that doesn't support SSL.", (Throwable)e);
            return HttpClients.createDefault();
        }
    }

    @VisibleForTesting
    HttpClientBuilder getHttpClientBuilder() {
        return HttpClients.custom();
    }

    @VisibleForTesting
    void setConnectionReuse(HttpClientBuilder httpClientBuilder) {
        httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)this.getConnectionReuseStrategy());
    }

    @VisibleForTesting
    void setSSLConnectionSocketFactory(HttpClientBuilder httpClientBuilder) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        });
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
    }

    @VisibleForTesting
    NoConnectionReuseStrategy getConnectionReuseStrategy() {
        return new NoConnectionReuseStrategy();
    }
}

