/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.sam.SamTaskDataProvider;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.common.rest.sam.SamTargetStateDto;
import com.appdynamics.sim.common.rest.sam.SamTargetsAgentService;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StateService.class);
    @Generated
    private final Object $lock = new Object[0];
    private String hostId;
    private final SamTargetsAgentService targetsAgentService;
    private final Scheduler scheduler;
    private final BootstrapConfiguration bootstrapConfig;
    private final SamTaskDataProvider samTaskDataProvider;
    private volatile ScheduledFuture<?> future;

    @Inject
    StateService(@HostId String hostId, SamTargetsAgentService targetsAgentService, Scheduler scheduler, BootstrapConfiguration bootstrapConfig, SamTaskDataProvider samTaskDataProvider) {
        this.hostId = hostId;
        this.targetsAgentService = targetsAgentService;
        this.scheduler = scheduler;
        this.bootstrapConfig = bootstrapConfig;
        this.samTaskDataProvider = samTaskDataProvider;
    }

    @PostConstruct
    private void startStateSender() {
        if (this.future == null) {
            this.future = this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    StateService.this.sendNow();
                }
            }, this.bootstrapConfig.getSamStateUpdateIntervalMillis().longValue(), this.bootstrapConfig.getSamStateUpdateIntervalMillis().longValue(), TimeUnit.MILLISECONDS);
        }
    }

    @PreDestroy
    private void stopStateSender() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNow() {
        Object object = this.$lock;
        synchronized (object) {
            try {
                Map<Long, SamTargetStateDto> healthStateMap = this.samTaskDataProvider.getCurrentHealth();
                log.debug("Sending the Service Availability Monitoring target state {}", healthStateMap);
                this.targetsAgentService.updateState(this.hostId, healthStateMap);
            }
            catch (RuntimeException e) {
                log.warn("Failed to send current health to the controller. Will try again later.", (Throwable)e);
            }
        }
    }
}

