/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.sam.SamTaskDataProvider;
import com.appdynamics.agent.sim.sam.checker.HttpTargetCheckerResult;
import com.appdynamics.agent.sim.sam.checker.SamEventData;
import com.appdynamics.sim.agent.extensions.api.events.EventSeverity;
import com.appdynamics.sim.agent.extensions.api.events.EventsService;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.common.rest.sam.SamTargetHttpFullDto;
import com.appdynamics.sim.common.rest.sam.SamTargetStateDto;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SamEventService.class);
    @Generated
    private final Object $lock = new Object[0];
    private final BootstrapConfiguration bootstrapConfig;
    private final Scheduler scheduler;
    private final EventsService eventsService;
    private final SamTaskDataProvider samTaskDataProvider;
    private ScheduledFuture<?> future;

    @Inject
    SamEventService(BootstrapConfiguration bootstrapConfig, Scheduler scheduler, EventsService eventsService, SamTaskDataProvider samTaskDataProvider) {
        this.bootstrapConfig = bootstrapConfig;
        this.scheduler = scheduler;
        this.eventsService = eventsService;
        this.samTaskDataProvider = samTaskDataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void startPeriodicEventTask() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future == null) {
                this.future = this.scheduler.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        SamEventService.this.sendPeriodicEvent();
                    }
                }, this.bootstrapConfig.getSamEventUpdateIntervalMillis().longValue(), this.bootstrapConfig.getSamEventUpdateIntervalMillis().longValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stopPeriodicEventTask() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPeriodicEvent() {
        Object object = this.$lock;
        synchronized (object) {
            Map<Long, SamEventData> latestEventDataMap = this.samTaskDataProvider.getLatestEventData();
            for (SamEventData samEventData : latestEventDataMap.values()) {
                if (samEventData == null) continue;
                log.debug("Sending periodic event for Service Availability Monitoring target id: {}, name: {}", (Object)samEventData.getSamTarget().getId(), (Object)samEventData.getSamTarget().getName());
                this.sendEvent(samEventData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(SamEventData eventData) {
        Object object = this.$lock;
        synchronized (object) {
            if (eventData == null) {
                return;
            }
            SamTargetHttpFullDto samTarget = eventData.getSamTarget();
            try {
                HttpTargetCheckerResult result = eventData.getCheckerResult();
                log.debug("Sending state change event for Service Availability Monitoring target id: {}, name: {}", (Object)samTarget.getId(), (Object)samTarget.getName());
                EventSeverity severity = this.getSeverityForCurrentStatus(eventData.getStateSnapshot());
                ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"targetId", (Object)samTarget.getId());
                ImmutableMap.Builder details = ImmutableMap.builder().put((Object)"request", (Object)eventData.getRequestString());
                if (result.getResponseResult().isPresent()) {
                    HttpTargetCheckerResult.ResponseResult responseResult = (HttpTargetCheckerResult.ResponseResult)result.getResponseResult().get();
                    properties.put((Object)"responseSizeBytes", (Object)responseResult.getResponseSize()).put((Object)"responseTimeMillis", (Object)responseResult.getResponseTime()).put((Object)"statusCode", (Object)responseResult.getStatusCode()).put((Object)"severity", (Object)severity.name());
                    details.put((Object)"response", (Object)responseResult.getFullResponse());
                }
                this.eventsService.reportCustomEvent(severity, "Service Availability", eventData.getValidationMessage(), (Map)properties.build(), (Map)details.build());
            }
            catch (RuntimeException e) {
                log.error("Failed sending the event data for target id: {}, name: {}", (Object)samTarget.getId(), (Object)samTarget.getName());
            }
        }
    }

    @VisibleForTesting
    EventSeverity getSeverityForCurrentStatus(@NonNull SamTargetStateDto currentState) {
        if (currentState == null) {
            throw new NullPointerException("currentState is marked non-null but is null");
        }
        switch (currentState) {
            case CRITICAL: 
            case WARNING: {
                return EventSeverity.ERROR;
            }
        }
        return EventSeverity.INFO;
    }
}

