/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.sam;

import com.appdynamics.agent.sim.sam.SamCheckerTaskRegistry;
import com.appdynamics.agent.sim.sam.SamTaskDataProvider;
import com.appdynamics.agent.sim.sam.checker.HttpTargetCheckerTask;
import com.appdynamics.agent.sim.sam.checker.SamEventData;
import com.appdynamics.sim.common.rest.sam.SamTargetHttpFullDto;
import com.appdynamics.sim.common.rest.sam.SamTargetStateDto;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

class SamCheckerTaskRegistryImpl
implements SamTaskDataProvider,
SamCheckerTaskRegistry {
    @Generated
    private final Object $lock = new Object[0];
    private static final Function<HttpTargetCheckerTask, SamTargetStateDto> extractHealth = new Function<HttpTargetCheckerTask, SamTargetStateDto>(){

        public SamTargetStateDto apply(HttpTargetCheckerTask input) {
            return input.getCurrentState();
        }
    };
    private static final Function<HttpTargetCheckerTask, SamEventData> extractLatestResult = new Function<HttpTargetCheckerTask, SamEventData>(){

        public SamEventData apply(HttpTargetCheckerTask input) {
            return input.getLatestEventData();
        }
    };
    private final HttpTargetCheckerTask.Factory taskFactory;
    private final List<HttpTargetCheckerTask> runningTasks;

    @Inject
    SamCheckerTaskRegistryImpl(HttpTargetCheckerTask.Factory taskFactory) {
        this.taskFactory = taskFactory;
        this.runningTasks = new ArrayList<HttpTargetCheckerTask>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAll() {
        Object object = this.$lock;
        synchronized (object) {
            for (HttpTargetCheckerTask task : this.runningTasks) {
                task.stopCheckService();
            }
            this.runningTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskFromConfig(SamTargetHttpFullDto config) {
        Object object = this.$lock;
        synchronized (object) {
            HttpTargetCheckerTask task = this.taskFactory.makeCheckerTask(config);
            task.startCheckService();
            this.runningTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, SamTargetStateDto> getCurrentHealth() {
        Object object = this.$lock;
        synchronized (object) {
            return this.transformRunningTasks(extractHealth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, SamEventData> getLatestEventData() {
        Object object = this.$lock;
        synchronized (object) {
            return this.transformRunningTasks(extractLatestResult);
        }
    }

    private <T> Map<Long, T> transformRunningTasks(Function<HttpTargetCheckerTask, T> function) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (HttpTargetCheckerTask task : this.runningTasks) {
            builder.put((Object)task.getId(), function.apply((Object)task));
        }
        return builder.build();
    }

    @Generated
    public String toString() {
        return "SamCheckerTaskRegistryImpl(runningTasks=" + String.valueOf(this.runningTasks) + ")";
    }
}

