/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.properties;

import com.appdynamics.agent.sim.utils.BashPathProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public class MachineLicensePropertiesProvider
implements Provider<Map<String, String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MachineLicensePropertiesProvider.class);
    private static final String LCPU = "lcpu=";
    private static final String AIX_LPARSTAT_COMMAND = "/usr/bin/lparstat | /usr/bin/grep lcpu=";
    private static final String SPACE = " ";
    private static final String EQUALS = "=";

    @VisibleForTesting
    protected LicenseCpuInfo getLicenseCpuInfo() throws Exception {
        LicenseCpuInfo result;
        block30: {
            try {
                if (this.isOsAix()) {
                    log.trace("Detected OS is AIX. Using Oshi and lparstat");
                    result = this.getOshiBasedLicenseCpuInfo();
                    int lcpus = result.getLogicalCpuCount();
                    boolean lcpuUpdatedWithLparstat = false;
                    try (InputStream inputStream = new ProcessBuilder(BashPathProvider.getBashPath(), "-c", AIX_LPARSTAT_COMMAND).start().getInputStream();
                         InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                         BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                        String line;
                        int lineNumber = 0;
                        while ((line = bufferedReader.readLine()) != null) {
                            String[] tokens;
                            for (String token : tokens = line.split(SPACE)) {
                                if (!token.startsWith(LCPU)) continue;
                                try {
                                    lcpus = Integer.parseInt(token.split(EQUALS)[1].trim());
                                    log.debug("Got the logical cpu count: {} using lpatstat", (Object)lcpus);
                                    lcpuUpdatedWithLparstat = true;
                                    break;
                                }
                                catch (Exception e) {
                                    log.debug("Error while parsing lcpus from lparstat command for AIX, {}, exception = {}", (Object)token, (Object)e.getMessage());
                                }
                            }
                            if (lcpuUpdatedWithLparstat) break;
                            if (lineNumber > 2) {
                                break;
                            }
                            ++lineNumber;
                        }
                    }
                    catch (Exception e) {
                        log.debug("Error while executing lparstat using ProcessBuilder, {}", (Object)e.getMessage());
                    }
                    if (lcpuUpdatedWithLparstat) {
                        result = new LicenseCpuInfo(result.getPhysicalCoreCount(), lcpus, result.getVirtualCpuCount());
                    }
                    break block30;
                }
                if (this.isOsHPUx()) {
                    log.trace("Detected OS is HP-UX. Using Sigar");
                    result = this.getSigarBasedLicenseCpuInfo();
                } else {
                    result = this.getOshiBasedLicenseCpuInfo();
                }
            }
            catch (Exception e) {
                log.warn("Error in fetching of CPU Info. Fall back to Sigar due to \"{}\"", (Object)e.getMessage());
                log.debug("Fall back exception", (Throwable)e);
                result = this.getSigarBasedLicenseCpuInfo();
            }
        }
        return result;
    }

    @VisibleForTesting
    protected LicenseCpuInfo getSigarBasedLicenseCpuInfo() throws SigarException {
        SigarProxy sigarProxy = this.getSigarProxy();
        CpuInfo[] cpuInfos = sigarProxy.getCpuInfoList();
        if (cpuInfos != null) {
            LicenseCpuInfo licenseCpuInfo = new LicenseCpuInfo(cpuInfos[0].getTotalSockets(), cpuInfos[0].getTotalCores(), cpuInfos[0].getTotalCores());
            log.trace("Sigar based output: {}", (Object)licenseCpuInfo);
            return licenseCpuInfo;
        }
        throw new UnsupportedOperationException("Error in fetching CPU Info");
    }

    @VisibleForTesting
    protected LicenseCpuInfo getOshiBasedLicenseCpuInfo() {
        HardwareAbstractionLayer hal = this.getHardwareAbstractionLayer();
        LicenseCpuInfo licenseCpuInfo = new LicenseCpuInfo(hal.getProcessor().getPhysicalProcessorCount(), hal.getProcessor().getLogicalProcessorCount(), hal.getProcessor().getLogicalProcessorCount());
        log.trace("Oshi based output: {}", (Object)licenseCpuInfo);
        return licenseCpuInfo;
    }

    @VisibleForTesting
    protected SigarProxy getSigarProxy() {
        return SigarProxyCache.newInstance();
    }

    @VisibleForTesting
    protected HardwareAbstractionLayer getHardwareAbstractionLayer() {
        SystemInfo si = new SystemInfo();
        return si.getHardware();
    }

    @VisibleForTesting
    protected boolean isOsAix() {
        return SystemUtils.IS_OS_AIX;
    }

    protected boolean isOsHPUx() {
        return SystemUtils.IS_OS_HP_UX;
    }

    public Map<String, String> get() {
        ImmutableMap.Builder propertyBuilder = ImmutableMap.builder();
        try {
            LicenseCpuInfo licenseCpuInfo = this.getLicenseCpuInfo();
            log.info("Detected Virtual CPU Count: {}", (Object)licenseCpuInfo.virtualCpuCount);
            log.info("Detected Logical CPU Count: {}", (Object)licenseCpuInfo.logicalCpuCount);
            log.info("Detected Physical CPU Count: {}", (Object)licenseCpuInfo.physicalCoreCount);
            this.populateCpuInfoProperties((ImmutableMap.Builder<String, String>)propertyBuilder, licenseCpuInfo);
        }
        catch (Exception e) {
            log.error("Could not get license related properties. Unsupported Operation System", (Throwable)e);
        }
        return propertyBuilder.build();
    }

    @VisibleForTesting
    protected void populateCpuInfoProperties(ImmutableMap.Builder<String, String> propertyBuilder, LicenseCpuInfo licenseCpuInfo) {
        propertyBuilder.put((Object)"vCPU", (Object)String.valueOf(licenseCpuInfo.virtualCpuCount));
        propertyBuilder.put((Object)"Processor|Logical Core Count", (Object)String.valueOf(licenseCpuInfo.logicalCpuCount));
        propertyBuilder.put((Object)"Processor|Physical Core Count", (Object)String.valueOf(licenseCpuInfo.physicalCoreCount));
    }

    static class LicenseCpuInfo {
        private final int physicalCoreCount;
        private final int logicalCpuCount;
        private final int virtualCpuCount;

        public LicenseCpuInfo(int physicalCoreCount, int logicalCpuCount, int vCPU) {
            this.physicalCoreCount = physicalCoreCount;
            this.logicalCpuCount = logicalCpuCount;
            this.virtualCpuCount = vCPU;
        }

        public int getPhysicalCoreCount() {
            return this.physicalCoreCount;
        }

        public int getLogicalCpuCount() {
            return this.logicalCpuCount;
        }

        public int getVirtualCpuCount() {
            return this.virtualCpuCount;
        }

        public String toString() {
            return "LicenseCpuInfo{physicalCoreCount=" + this.physicalCoreCount + ", logicalCpuCount=" + this.logicalCpuCount + ", virtualCpuCount=" + this.virtualCpuCount + "}";
        }
    }
}

