/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.properties;

import com.appdynamics.agent.sim.properties.MachineLicensePropertiesProvider;
import com.appdynamics.agent.sim.properties.MonitoredMachineProperties;
import com.appdynamics.agent.sim.scheduling.annotations.SystemScheduler;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineLicensePropertiesMonitor
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MachineLicensePropertiesMonitor.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final long MACHINE_LICENSE_UPDATE_INTERVAL_MILLIS = 30000L;
    private final ScheduledExecutorService scheduler;
    private final MachineProperties machineProperties;
    private final MachineLicensePropertiesProvider propertiesProvider;
    private volatile ScheduledFuture<?> future;
    private volatile MachineLicensePropertiesProvider.LicenseCpuInfo licenseCpuInfo;

    @Inject
    MachineLicensePropertiesMonitor(@SystemScheduler ScheduledExecutorService scheduler, MachineProperties machineProperties, @MonitoredMachineProperties MachineLicensePropertiesProvider propertiesProvider) {
        this.scheduler = scheduler;
        this.machineProperties = machineProperties;
        this.propertiesProvider = propertiesProvider;
    }

    @Override
    public void run() {
        try {
            MachineLicensePropertiesProvider.LicenseCpuInfo latestCpuInfo = this.propertiesProvider.getLicenseCpuInfo();
            if (this.licenseCpuInfo.getVirtualCpuCount() != latestCpuInfo.getVirtualCpuCount()) {
                this.licenseCpuInfo = latestCpuInfo;
                log.info("Detected new Virtual CPU Count: {}", (Object)this.licenseCpuInfo.getVirtualCpuCount());
                log.info("Detected new Logical CPU Count: {}", (Object)this.licenseCpuInfo.getLogicalCpuCount());
                log.info("Detected new Physical CPU Count: {}", (Object)this.licenseCpuInfo.getPhysicalCoreCount());
            }
            ImmutableMap.Builder propertyBuilder = ImmutableMap.builder();
            this.propertiesProvider.populateCpuInfoProperties((ImmutableMap.Builder<String, String>)propertyBuilder, this.licenseCpuInfo);
            propertyBuilder.build().forEach((key, value) -> this.machineProperties.updateProperty(key, value));
        }
        catch (Exception e) {
            log.error("Error while running monitor", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void start() {
        Object object = this.$lock;
        synchronized (object) {
            try {
                if (this.licenseCpuInfo == null) {
                    this.licenseCpuInfo = this.propertiesProvider.getLicenseCpuInfo();
                }
                if (this.future == null) {
                    log.debug("Scheduling monitor to run every {} milliseconds", (Object)30000L);
                    this.future = this.scheduler.scheduleAtFixedRate(this, 30000L, 30000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                log.error("Error in scheduling monitor", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stop() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Stopping monitor.");
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            this.licenseCpuInfo = null;
        }
    }
}

