/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.properties;

import com.appdynamics.agent.sim.configuration.bootstrap.AgentHomeDir;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.singularity.ee.agent.systemagent.SystemAgent;
import com.singularity.ee.agent.util.SystemInfo;
import com.singularity.ee.util.log4j.Log4JLogger;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.system.SystemUtils;
import java.util.Map;
import org.apache.logging.log4j.LogManager;

public class MachineAgentInstallPropertiesProvider
implements Provider<Map<String, String>> {
    private final ImmutableMap<String, String> agentInstallProperties;
    private final ILogger logger = new Log4JLogger(LogManager.getLogger((String)this.getClass().getName()));

    @Inject
    public MachineAgentInstallPropertiesProvider(@AgentHomeDir String agentHomeDir) {
        Optional implVersionOpt;
        String smartAgent;
        String ansibleInstalledAgents;
        ImmutableMap.Builder propertyBuilder = ImmutableMap.builder();
        propertyBuilder.put((Object)"AppDynamics|Agent|Machine Info", (Object)SystemInfo.getMachineInfo());
        propertyBuilder.put((Object)"AppDynamics|Agent|JVM Info", (Object)SystemInfo.getVMInfo());
        propertyBuilder.put((Object)"AppDynamics|Agent|Install Directory", (Object)agentHomeDir);
        String pid = SystemUtils.getVMPID((ILogger)this.logger);
        if (pid != null) {
            propertyBuilder.put((Object)"AppDynamics|Agent|Agent Pid", (Object)pid);
        }
        if ((ansibleInstalledAgents = System.getenv("APPDYNAMICS_ANSIBLE_INSTALLED_AGENTS")) != null) {
            propertyBuilder.put((Object)"APPDYNAMICS_ANSIBLE_INSTALLED_AGENTS", (Object)ansibleInstalledAgents);
        }
        if ((smartAgent = System.getenv("APPD_SMART_AGENT")) != null) {
            propertyBuilder.put((Object)"AppDynamics|Agent|Smart Agent Id", (Object)smartAgent);
        }
        if ((implVersionOpt = Optional.fromNullable((Object)SystemAgent.class.getPackage().getImplementationVersion())).isPresent()) {
            propertyBuilder.put((Object)"AppDynamics|Agent|Agent version", (Object)((String)implVersionOpt.get()));
        }
        this.agentInstallProperties = propertyBuilder.build();
    }

    public Map<String, String> get() {
        return this.agentInstallProperties;
    }
}

