/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.properties;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MachineAgentBuildPropertiesProvider
implements Provider<Map<String, String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MachineAgentBuildPropertiesProvider.class);
    private static final String UNKNOWN_BUILD_NUMBER = "unknown";

    MachineAgentBuildPropertiesProvider() {
    }

    public Map<String, String> get() {
        ImmutableMap.Builder propertyBuilder = ImmutableMap.builder();
        propertyBuilder.putAll(this.getBuildProperties());
        return propertyBuilder.build();
    }

    private Map<String, String> getBuildProperties() {
        HashMap<String, String> hashMap;
        block9: {
            InputStream stream = this.getClass().getResourceAsStream("/build.properties");
            try {
                Properties properties = new Properties();
                properties.load(stream);
                HashMap<String, String> propertyMap = new HashMap<String, String>();
                for (String propertyName : properties.stringPropertyNames()) {
                    propertyMap.put(propertyName, properties.getProperty(propertyName));
                }
                hashMap = propertyMap;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Failed to read build properties");
                    return Collections.singletonMap("AppDynamics|Agent|Build Number", UNKNOWN_BUILD_NUMBER);
                }
            }
            stream.close();
        }
        return hashMap;
    }
}

