/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.prometheus.text;

import com.appdynamics.agent.sim.prometheus.PrometheusMetricDataParser;
import com.appdynamics.agent.sim.prometheus.PrometheusUtils;
import com.appdynamics.agent.sim.prometheus.text.TextSample;
import com.appdynamics.agent.sim.prometheus.types.Counter;
import com.appdynamics.agent.sim.prometheus.types.CustomMetricFamily;
import com.appdynamics.agent.sim.prometheus.types.Gauge;
import com.appdynamics.agent.sim.prometheus.types.Histogram;
import com.appdynamics.agent.sim.prometheus.types.Metric;
import com.appdynamics.agent.sim.prometheus.types.MetricType;
import com.appdynamics.agent.sim.prometheus.types.Summary;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPrometheusMetricDataParser
extends PrometheusMetricDataParser<CustomMetricFamily> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextPrometheusMetricDataParser.class);
    private String lastLineReadFromStream;

    public TextPrometheusMetricDataParser(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public CustomMetricFamily parse() throws IOException {
        String line;
        if (this.lastLineReadFromStream != null) {
            line = this.lastLineReadFromStream;
            this.lastLineReadFromStream = null;
        } else {
            line = this.readLine(this.getInputStream());
        }
        if (line == null) {
            return null;
        }
        if (!line.isEmpty() && !new String(new char[]{line.charAt(0)}).matches("\\p{ASCII}*")) {
            throw new IOException("Doesn't look like the metric data is in text format");
        }
        ParserContext context = new ParserContext();
        while (line != null) {
            line = line.trim();
            try {
                if (!line.isEmpty()) {
                    if (line.charAt(0) == '#') {
                        String[] parts = line.split("[ \t]+", 4);
                        if (parts.length >= 2) {
                            if (parts[1].equals("HELP")) {
                                if (!parts[2].equals(context.name)) {
                                    if (!context.name.isEmpty()) {
                                        this.lastLineReadFromStream = line;
                                        break;
                                    }
                                    context.clear();
                                    context.name = parts[2];
                                    context.type = MetricType.GAUGE;
                                    context.allowedNames.add(parts[2]);
                                }
                                context.help = parts.length == 4 ? this.unescapeHelp(parts[3]) : "";
                            } else if (parts[1].equals("TYPE")) {
                                if (!parts[2].equals(context.name)) {
                                    if (!context.name.isEmpty()) {
                                        this.lastLineReadFromStream = line;
                                        break;
                                    }
                                    context.clear();
                                    context.name = parts[2];
                                }
                                context.type = MetricType.valueOf(parts[3].toUpperCase());
                                context.allowedNames.clear();
                                switch (context.type) {
                                    case COUNTER: {
                                        context.allowedNames.add(context.name);
                                        break;
                                    }
                                    case GAUGE: {
                                        context.allowedNames.add(context.name);
                                        break;
                                    }
                                    case SUMMARY: {
                                        context.allowedNames.add(context.name + "_count");
                                        context.allowedNames.add(context.name + "_sum");
                                        context.allowedNames.add(context.name);
                                        break;
                                    }
                                    case HISTOGRAM: {
                                        context.allowedNames.add(context.name + "_count");
                                        context.allowedNames.add(context.name + "_sum");
                                        context.allowedNames.add(context.name + "_bucket");
                                    }
                                }
                            }
                        }
                    } else {
                        TextSample sample = this.parseSampleLine(line);
                        if (!context.allowedNames.contains(sample.getName())) {
                            if (!context.name.isEmpty()) {
                                this.lastLineReadFromStream = line;
                                break;
                            }
                            context.clear();
                            log.debug("Ignoring an unexpected metric: " + line);
                        } else {
                            context.textSamples.add(sample);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.debug("Failed to process line - it will be ignored: {}", (Object)line);
            }
            line = this.readLine(this.getInputStream());
        }
        if (!context.name.isEmpty()) {
            context.finishMetricFamily();
        }
        return context.finishedMetricFamily;
    }

    private TextSample parseSampleLine(String line) {
        StringBuilder name = new StringBuilder();
        StringBuilder labelname = new StringBuilder();
        StringBuilder labelvalue = new StringBuilder();
        StringBuilder value = new StringBuilder();
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        String state = "name";
        for (int c = 0; c < line.length(); ++c) {
            char charAt = line.charAt(c);
            if (state.equals("name")) {
                if (charAt == '{') {
                    state = "startoflabelname";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') {
                    state = "endofname";
                    continue;
                }
                name.append(charAt);
                continue;
            }
            if (state.equals("endofname")) {
                if (charAt == ' ' || charAt == '\t') continue;
                if (charAt == '{') {
                    state = "startoflabelname";
                    continue;
                }
                value.append(charAt);
                state = "value";
                continue;
            }
            if (state.equals("startoflabelname")) {
                if (charAt == ' ' || charAt == '\t') continue;
                if (charAt == '}') {
                    state = "endoflabels";
                    continue;
                }
                labelname.append(charAt);
                state = "labelname";
                continue;
            }
            if (state.equals("labelname")) {
                if (charAt == '=') {
                    state = "labelvaluequote";
                    continue;
                }
                if (charAt == '}') {
                    state = "endoflabels";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') {
                    state = "labelvalueequals";
                    continue;
                }
                labelname.append(charAt);
                continue;
            }
            if (state.equals("labelvalueequals")) {
                if (charAt == '=') {
                    state = "labelvaluequote";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') continue;
                throw new IllegalStateException("Invalid line: " + line);
            }
            if (state.equals("labelvaluequote")) {
                if (charAt == '\"') {
                    state = "labelvalue";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') continue;
                throw new IllegalStateException("Invalid line: " + line);
            }
            if (state.equals("labelvalue")) {
                if (charAt == '\\') {
                    state = "labelvalueslash";
                    continue;
                }
                if (charAt == '\"') {
                    labels.put(labelname.toString(), labelvalue.toString());
                    labelname.setLength(0);
                    labelvalue.setLength(0);
                    state = "nextlabel";
                    continue;
                }
                labelvalue.append(charAt);
                continue;
            }
            if (state.equals("labelvalueslash")) {
                state = "labelvalue";
                if (charAt == '\\') {
                    labelvalue.append('\\');
                    continue;
                }
                if (charAt == 'n') {
                    labelvalue.append('\n');
                    continue;
                }
                if (charAt == '\"') {
                    labelvalue.append('\"');
                    continue;
                }
                labelvalue.append('\\').append(charAt);
                continue;
            }
            if (state.equals("nextlabel")) {
                if (charAt == ',') {
                    state = "labelname";
                    continue;
                }
                if (charAt == '}') {
                    state = "endoflabels";
                    continue;
                }
                if (charAt == ' ' || charAt == '\t') continue;
                throw new IllegalStateException("Invalid line: " + line);
            }
            if (state.equals("endoflabels")) {
                if (charAt == ' ' || charAt == '\t') continue;
                value.append(charAt);
                state = "value";
                continue;
            }
            if (!state.equals("value")) continue;
            if (charAt == ' ' || charAt == '\t') break;
            value.append(charAt);
        }
        TextSample sample = ((TextSample.Builder)((TextSample.Builder)new TextSample.Builder().setLine(line).setName(name.toString())).setValue(value.toString()).addLabels(labels)).build();
        return sample;
    }

    private String unescapeHelp(String text) {
        if (text == null || !text.contains("\\")) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        boolean slash = false;
        for (int c = 0; c < text.length(); ++c) {
            char charAt = text.charAt(c);
            if (slash) {
                if (charAt == '\\') {
                    result.append('\\');
                } else if (charAt == 'n') {
                    result.append('\n');
                } else {
                    result.append('\\').append(charAt);
                }
                slash = false;
                continue;
            }
            if (charAt == '\\') {
                slash = true;
                continue;
            }
            result.append(charAt);
        }
        if (slash) {
            result.append("\\");
        }
        return result.toString();
    }

    private String readLine(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int lineChar = inputStream.read();
            while (lineChar != 10 && lineChar != -1) {
                baos.write(lineChar);
                lineChar = inputStream.read();
            }
            if (lineChar == -1 && baos.size() == 0) {
                String string = null;
                return string;
            }
            String string = baos.toString("UTF-8");
            return string;
        }
    }

    private class ParserContext {
        public CustomMetricFamily finishedMetricFamily;
        public String name = "";
        public String help = "";
        public MetricType type = null;
        public List<String> allowedNames = new ArrayList<String>();
        public List<TextSample> textSamples = new ArrayList<TextSample>();

        private ParserContext() {
        }

        public void clear() {
            this.name = "";
            this.help = "";
            this.type = null;
            this.allowedNames.clear();
            this.textSamples.clear();
        }

        public void finishMetricFamily() {
            if (this.finishedMetricFamily != null) {
                return;
            }
            CustomMetricFamily.Builder metricFamilyBuilder = new CustomMetricFamily.Builder();
            metricFamilyBuilder.setName(this.name);
            metricFamilyBuilder.setHelp(this.help);
            metricFamilyBuilder.setType(this.type);
            LinkedHashMap<ImmutableMap, Object> builders = new LinkedHashMap<ImmutableMap, Object>();
            for (TextSample textSample : this.textSamples) {
                try {
                    ImmutableMap labels = ImmutableMap.copyOf(textSample.getLabels());
                    switch (this.type) {
                        case COUNTER: {
                            builders.put(labels, ((Counter.Builder)new Counter.Builder().setName(this.name)).setValue(PrometheusUtils.convertStringToDouble(textSample.getValue())).addLabels(textSample.getLabels()));
                            break;
                        }
                        case GAUGE: {
                            builders.put(labels, ((Gauge.Builder)new Gauge.Builder().setName(this.name)).setValue(PrometheusUtils.convertStringToDouble(textSample.getValue())).addLabels(textSample.getLabels()));
                            break;
                        }
                        case SUMMARY: {
                            String quantileValue = textSample.getLabels().remove("quantile");
                            Summary.Builder sBuilder = (Summary.Builder)builders.get(textSample.getLabels());
                            if (sBuilder == null) {
                                sBuilder = new Summary.Builder();
                                builders.put(labels, sBuilder);
                            }
                            sBuilder.setName(this.name);
                            sBuilder.addLabels(textSample.getLabels());
                            if (textSample.getName().endsWith("_count")) {
                                sBuilder.setSampleCount((long)PrometheusUtils.convertStringToDouble(textSample.getValue()));
                                break;
                            }
                            if (textSample.getName().endsWith("_sum")) {
                                sBuilder.setSampleSum(PrometheusUtils.convertStringToDouble(textSample.getValue()));
                                break;
                            }
                            if (quantileValue == null) {
                                log.debug("Summary quantile sample is missing the 'quantile' label: {}", (Object)textSample.getLine());
                                break;
                            }
                            sBuilder.addQuantile(PrometheusUtils.convertStringToDouble(quantileValue), PrometheusUtils.convertStringToDouble(textSample.getValue()));
                            break;
                        }
                        case HISTOGRAM: {
                            String bucket = textSample.getLabels().remove("le");
                            Histogram.Builder hBuilder = (Histogram.Builder)builders.get(textSample.getLabels());
                            if (hBuilder == null) {
                                hBuilder = new Histogram.Builder();
                                builders.put(labels, hBuilder);
                            }
                            hBuilder.setName(this.name);
                            hBuilder.addLabels(textSample.getLabels());
                            if (textSample.getName().endsWith("_count")) {
                                hBuilder.setSampleCount((long)PrometheusUtils.convertStringToDouble(textSample.getValue()));
                                break;
                            }
                            if (textSample.getName().endsWith("_sum")) {
                                hBuilder.setSampleSum(PrometheusUtils.convertStringToDouble(textSample.getValue()));
                                break;
                            }
                            if (bucket == null) {
                                throw new Exception("Histogram bucket sample is missing the 'le' label");
                            }
                            hBuilder.addBucket(PrometheusUtils.convertStringToDouble(bucket), (long)PrometheusUtils.convertStringToDouble(textSample.getValue()));
                        }
                    }
                }
                catch (Exception e) {
                    log.debug("Error processing sample. This metric sample will be ignored: {}; Exception: {}", (Object)textSample.getLine(), (Object)e);
                }
            }
            for (Metric.Builder builder : builders.values()) {
                try {
                    metricFamilyBuilder.addMetric(builder.build());
                }
                catch (Exception e) {
                    log.debug("Error building metric for metric family {} - it will be ignored; Exception: {}", (Object)this.name, (Object)e);
                }
            }
            try {
                this.finishedMetricFamily = metricFamilyBuilder.build();
            }
            catch (IllegalArgumentException e) {
                log.error("Error occurred while creating a Metric Family: ", (Throwable)e);
            }
        }
    }
}

