/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.prometheus;

import com.appdynamics.agent.sim.prometheus.PrometheusDataFormat;
import com.appdynamics.agent.sim.prometheus.text.TextPrometheusMetricsProcessor;
import com.appdynamics.agent.sim.prometheus.walkers.IPrometheusMetricsWalker;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusScraper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusScraper.class);
    private final URL url;
    private final PrometheusDataFormat knownDataFormat;

    public PrometheusScraper(String host, int port, String context) throws MalformedURLException {
        if (host == null) {
            host = "127.0.0.1";
        }
        if (port == 0) {
            port = 9400;
        }
        if (context == null || context.isEmpty()) {
            context = "/metrics";
        }
        this.url = new URL("http", host, port, context);
        this.knownDataFormat = PrometheusDataFormat.TEXT;
        log.debug("Prometheus data will be scraped from URL " + String.valueOf(this.url));
    }

    public PrometheusScraper(URL url, PrometheusDataFormat dataFormat) {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
        this.url = url;
        this.knownDataFormat = dataFormat;
        log.debug("Prometheus data will be scraped from URL {} with data format {}", (Object)this.url, this.knownDataFormat == null ? "<TBD>" : this.knownDataFormat);
    }

    public <M> void scrape(IPrometheusMetricsWalker<M> walker, M metricData) throws IOException {
        OpenConnectionDetails connectionDetails = this.openConnection(this.url);
        if (connectionDetails == null || connectionDetails.inputStream == null) {
            throw new IOException("Failed to open the connection to the Prometheus endpoint");
        }
        try (InputStream inputStream = connectionDetails.inputStream;){
            TextPrometheusMetricsProcessor<M> processor = new TextPrometheusMetricsProcessor<M>(inputStream, walker, metricData);
            processor.walk();
        }
    }

    @Deprecated
    protected String getBinaryFormatContentType() {
        return PrometheusDataFormat.BINARY.getContentType();
    }

    protected String getTextFormatContentType() {
        return PrometheusDataFormat.TEXT.getContentType();
    }

    protected OpenConnectionDetails openConnection(URL endpointUrl) throws IOException {
        URLConnection conn = endpointUrl.openConnection();
        if (conn == null) {
            throw new IOException("Unable to create a connection for the Prometheus Endpoint");
        }
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(30000);
        conn.setRequestProperty("Accept", this.getTextFormatContentType());
        try {
            InputStream stream = conn.getInputStream();
            String contentType = conn.getContentType();
            return new OpenConnectionDetails(stream, contentType);
        }
        catch (SocketTimeoutException e) {
            log.debug("SocketTimeoutException: Connection timed out while connecting to {}. Connect timeout set to {} ms, read timeout set to {} ms. Error: {}", new Object[]{endpointUrl, 10000, 30000, e.getMessage()});
            throw e;
        }
    }

    protected static class OpenConnectionDetails {
        public final InputStream inputStream;
        public final String contentType;

        public OpenConnectionDetails(InputStream is, String contentType) {
            this.inputStream = is;
            this.contentType = contentType;
        }
    }
}

