/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.monitor;

import com.appdynamics.agent.sim.monitor.MachinePropertyData;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.MonitorOutputHandler;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MachinePropertyOutputHandler
extends MonitorOutputHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MachinePropertyOutputHandler.class);
    public static final String NAME = "property";
    public static final String VALUE = "value";
    private final MachineProperties machineProperties;

    @Inject
    MachinePropertyOutputHandler(MachineProperties machineProperties) {
        this.machineProperties = machineProperties;
    }

    @Override
    public void parseAndReportLine(String monitorLine) {
        if (!monitorLine.toLowerCase().startsWith(NAME)) {
            return;
        }
        try {
            MachinePropertyData data = MachinePropertyOutputHandler.createMachinePropertyData(monitorLine);
            this.machineProperties.updateProperty(data.getName(), data.getValue());
        }
        catch (IllegalArgumentException e) {
            log.warn("Could not parse machine property output: " + monitorLine, (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Invalid machine property output: " + monitorLine, (Throwable)e);
        }
    }

    @VisibleForTesting
    static MachinePropertyData createMachinePropertyData(String propertyLine) {
        Map<String, String> tokenMap = MachinePropertyOutputHandler.createTokenMap(propertyLine);
        String propertyName = tokenMap.remove(NAME);
        if (propertyName == null) {
            throw new IllegalArgumentException("property token not found");
        }
        if (propertyName.isEmpty()) {
            throw new IllegalArgumentException(String.format("The value for token %s was empty", NAME));
        }
        if (!tokenMap.containsKey(VALUE)) {
            throw new IllegalArgumentException("value token not found");
        }
        String propertyValue = tokenMap.remove(VALUE);
        return new MachinePropertyData(propertyName, propertyValue);
    }
}

