/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.metrics;

import com.appdynamics.agent.sim.metrics.AggregatorCache;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricClusterRollupType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricHoleHandlingType;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricTimeRollupType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricRegistrationException;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricIdentifier;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporterFactory;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricOverflowException;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricReporterTypeMismatchException;
import com.singularity.ee.controller.api.constants.MetricClusterRollupType;
import com.singularity.ee.controller.api.constants.MetricHoleHandlingType;
import com.singularity.ee.controller.api.constants.MetricTimeRollupType;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsService
implements MetricsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricsService.class);
    private final Provider<IMetricReporterFactory> metricReporterFactory;
    private final Cache<String, IMetricAggregator> aggregators;

    @Inject
    @VisibleForTesting
    public DefaultMetricsService(Provider<IMetricReporterFactory> metricReporterFactory, @AggregatorCache Cache<String, IMetricAggregator> aggregators) {
        this.metricReporterFactory = metricReporterFactory;
        this.aggregators = aggregators;
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricTimeRollupType timeRollupType, ExtensionMetricClusterRollupType clusterRollupType, ExtensionMetricHoleHandlingType holeHandlingType, long value) {
        IMetricAggregator aggregator;
        try {
            aggregator = this.getOrCreateAggregator(metricName, aggregatorType, timeRollupType, clusterRollupType, holeHandlingType);
        }
        catch (MetricRegistrationException e) {
            return false;
        }
        aggregator.report(value);
        return true;
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricTimeRollupType timeRollupType, ExtensionMetricClusterRollupType clusterRollupType, ExtensionMetricHoleHandlingType holeHandlingType, RawDataLong rawValue) {
        if (!rawValue.isPresent()) {
            this.logError(metricName, rawValue.getError());
            return false;
        }
        return this.reportMetric(metricName, aggregatorType, timeRollupType, clusterRollupType, holeHandlingType, rawValue.get());
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricHoleHandlingType holeHandlingType, long value) {
        return this.reportMetric(metricName, aggregatorType, DefaultMetricsService.timeRollupTypeFromAggregatorType(aggregatorType), DefaultMetricsService.clusterRollupTypeFromAggregatorType(aggregatorType), holeHandlingType, value);
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, ExtensionMetricHoleHandlingType holeHandlingType, RawDataLong rawValue) {
        return this.reportMetric(metricName, aggregatorType, DefaultMetricsService.timeRollupTypeFromAggregatorType(aggregatorType), DefaultMetricsService.clusterRollupTypeFromAggregatorType(aggregatorType), holeHandlingType, rawValue);
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, long value) {
        return this.reportMetric(metricName, aggregatorType, DefaultMetricsService.timeRollupTypeFromAggregatorType(aggregatorType), DefaultMetricsService.clusterRollupTypeFromAggregatorType(aggregatorType), ExtensionMetricHoleHandlingType.REGULAR_COUNTER, value);
    }

    public boolean reportMetric(String metricName, ExtensionMetricAggregatorType aggregatorType, RawDataLong value) {
        return this.reportMetric(metricName, aggregatorType, DefaultMetricsService.timeRollupTypeFromAggregatorType(aggregatorType), DefaultMetricsService.clusterRollupTypeFromAggregatorType(aggregatorType), ExtensionMetricHoleHandlingType.REGULAR_COUNTER, value);
    }

    @VisibleForTesting
    IMetricAggregator getOrCreateAggregator(final String metricName, final ExtensionMetricAggregatorType aggregatorType, final ExtensionMetricTimeRollupType timeRollupType, final ExtensionMetricClusterRollupType clusterRollupType, final ExtensionMetricHoleHandlingType holeHandlingType) throws MetricRegistrationException {
        IMetricAggregator aggregator = (IMetricAggregator)this.aggregators.getIfPresent((Object)metricName);
        if (aggregator == null) {
            try {
                aggregator = (IMetricAggregator)this.aggregators.get((Object)metricName, (Callable)new Callable<IMetricAggregator>(){

                    @Override
                    public IMetricAggregator call() throws Exception {
                        AgentRawMetricIdentifier id = new AgentRawMetricIdentifier(metricName, DefaultMetricsService.aggregatorTypeFromExtension(aggregatorType), DefaultMetricsService.timeRollupTypeFromExtension(timeRollupType), DefaultMetricsService.clusterRollupTypeFromExtension(clusterRollupType), DefaultMetricsService.holeHandlingTypeFromExtension(holeHandlingType));
                        return ((IMetricReporterFactory)DefaultMetricsService.this.metricReporterFactory.get()).safeGetAggregator(id);
                    }
                });
            }
            catch (Exception e) {
                String msg;
                if (e.getCause() instanceof MetricReporterTypeMismatchException) {
                    msg = "Attempted to register metric " + metricName + " with different aggregation types than already existing. Could not report metric.";
                } else if (e.getCause() instanceof MetricOverflowException) {
                    int maxMetrics = SystemUtilsTranslateable.getIntProperty((String)"appdynamics.agent.maxMetrics", (int)1450);
                    msg = "Exceeded the number of metrics the agent is allowed to send (" + maxMetrics + "). Could not report metric " + metricName + ".";
                } else {
                    msg = "Unexpected error reporting metric " + metricName;
                }
                throw new MetricRegistrationException(msg, (Throwable)e);
            }
        }
        return aggregator;
    }

    @VisibleForTesting
    static ExtensionMetricClusterRollupType clusterRollupTypeFromAggregatorType(ExtensionMetricAggregatorType aggregatorType) {
        switch (aggregatorType) {
            case AVAILABILITY: 
            case AVERAGE: 
            case OBSERVATION: 
            case PERCENTILE: {
                return ExtensionMetricClusterRollupType.INDIVIDUAL;
            }
            case SUM: {
                return ExtensionMetricClusterRollupType.COLLECTIVE;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregator rollup type: " + String.valueOf(aggregatorType));
    }

    @VisibleForTesting
    static ExtensionMetricTimeRollupType timeRollupTypeFromAggregatorType(ExtensionMetricAggregatorType aggregatorType) {
        switch (aggregatorType) {
            case AVAILABILITY: 
            case AVERAGE: 
            case OBSERVATION: 
            case PERCENTILE: {
                return ExtensionMetricTimeRollupType.AVERAGE;
            }
            case SUM: {
                return ExtensionMetricTimeRollupType.SUM;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregator rollup type: " + String.valueOf(aggregatorType));
    }

    @VisibleForTesting
    static MetricTimeRollupType timeRollupTypeFromExtension(ExtensionMetricTimeRollupType type) {
        return MetricTimeRollupType.valueOf((String)type.name());
    }

    @VisibleForTesting
    static MetricClusterRollupType clusterRollupTypeFromExtension(ExtensionMetricClusterRollupType type) {
        return MetricClusterRollupType.valueOf((String)type.name());
    }

    @VisibleForTesting
    static MetricAggregatorType aggregatorTypeFromExtension(ExtensionMetricAggregatorType aggregatorType) {
        return MetricAggregatorType.valueOf((String)aggregatorType.name());
    }

    @VisibleForTesting
    static MetricHoleHandlingType holeHandlingTypeFromExtension(ExtensionMetricHoleHandlingType type) {
        return MetricHoleHandlingType.valueOf((String)type.name());
    }

    @VisibleForTesting
    void logError(String metricName, String errorMsg) {
        log.debug("Error while reporting metric '{}'. Error: {}", (Object)metricName, (Object)errorMsg);
    }
}

