/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.main;

import com.appdynamics.agent.sim.common.SimMachineIdsModule;
import com.appdynamics.agent.sim.dmm.AgentDynamicMonitoringModule;
import com.appdynamics.agent.sim.events.AgentEventsModule;
import com.appdynamics.agent.sim.extensions.AgentExtensionsModule;
import com.appdynamics.agent.sim.legacy.LegacyAgentModule;
import com.appdynamics.agent.sim.lightagent.LightAgentDmmModule;
import com.appdynamics.agent.sim.lightagent.LightAgentNonDmmModule;
import com.appdynamics.agent.sim.lightagent.LightSystemAgentModule;
import com.appdynamics.agent.sim.metrics.AgentDynamicMonitoringMetricsModule;
import com.appdynamics.agent.sim.metrics.AgentMetricsModule;
import com.appdynamics.agent.sim.monitor.MonitorModule;
import com.appdynamics.agent.sim.sam.SamModule;
import com.appdynamics.agent.sim.scheduling.annotations.SystemScheduler;
import com.appdynamics.sim.common.biz.shared.machines.AgentRegistrationConfig;
import com.appdynamics.sim.common.biz.shared.machines.Features;
import com.appdynamics.sim.common.biz.shared.machines.TransientFeatures;
import com.appdynamics.voltron.FrameworkBootstrap;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondStageSystem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecondStageSystem.class);
    @Generated
    private final Object $lock = new Object[0];
    private final ScheduledExecutorService executorService;
    private final Injector bootstrapInjector;
    private final FrameworkBootstrap.Factory bootstrapFactory;
    @VisibleForTesting
    private volatile Features enabledFeatures;
    private volatile long prevMieId;
    private volatile FrameworkBootstrap.Context context;
    private volatile boolean destroyed;

    @Inject
    SecondStageSystem(@SystemScheduler ScheduledExecutorService executorService, Injector bootstrapInjector, FrameworkBootstrap.Factory bootstrapFactory) {
        this.executorService = executorService;
        this.bootstrapInjector = bootstrapInjector;
        this.bootstrapFactory = bootstrapFactory;
        this.enabledFeatures = Features.EMPTY;
        this.destroyed = false;
        this.prevMieId = 0L;
    }

    void apply(@NonNull Features newFeatures) {
        if (newFeatures == null) {
            throw new NullPointerException("newFeatures is marked non-null but is null");
        }
        log.debug("Applying config {}", (Object)newFeatures);
        if (!this.enabledFeatures.equals((Object)newFeatures)) {
            log.debug("Features changed from {} to {}", (Object)this.enabledFeatures, (Object)newFeatures);
            this.loadFeaturesInBackground(newFeatures);
        } else {
            log.debug("No changes to apply.");
        }
    }

    void apply(@NonNull AgentRegistrationConfig agentRegistrationConfig) {
        if (agentRegistrationConfig == null) {
            throw new NullPointerException("agentRegistrationConfig is marked non-null but is null");
        }
        long mieId = Long.parseLong(agentRegistrationConfig.getMachineInstanceEntityId());
        if (this.prevMieId != 0L && mieId != this.prevMieId && !this.enabledFeatures.getFeatures().isEmpty()) {
            log.debug("Machine ID has changed from {} to {}. Resetting the agent.", (Object)this.prevMieId, (Object)mieId);
            this.loadFeaturesInBackground(this.enabledFeatures);
        }
        this.prevMieId = mieId;
    }

    void apply(@NonNull TransientFeatures transientFeatures) {
        if (transientFeatures == null) {
            throw new NullPointerException("transientFeatures is marked non-null but is null");
        }
        if (!transientFeatures.getFeatures().isEmpty()) {
            log.debug("Transient features are detected. Resetting the agent.");
            this.loadFeaturesInBackground(this.enabledFeatures);
        }
    }

    boolean hasFeature(String feature) {
        return this.enabledFeatures.has(feature);
    }

    private void loadFeaturesInBackground(final Features newFeatures) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                SecondStageSystem.this.loadFeatures(newFeatures);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFeatures(Features newFeatures) {
        Object object = this.$lock;
        synchronized (object) {
            this.stop();
            log.debug("Starting main with changed features.");
            this.enabledFeatures = newFeatures;
            this.start();
            log.debug("Finished starting new main system.");
        }
    }

    @VisibleForTesting
    void start() {
        if (this.destroyed) {
            log.debug("Tried to start main system after it was already destroyed.");
            return;
        }
        if (this.context == null) {
            log.info("Starting main system with features {}", (Object)this.enabledFeatures);
            if (this.enabledFeatures.equals((Object)Features.EMPTY)) {
                log.info("Not starting main system since no features specified with reason: " + this.enabledFeatures.getReason().getMessage());
                return;
            }
            FrameworkBootstrap bootstrap = this.bootstrapFactory.make().requireExplictBindings().setParentInjector(this.bootstrapInjector);
            if (this.enabledFeatures.has("basic") || this.enabledFeatures.has("sim")) {
                SecondStageSystem.addBasicModules(bootstrap);
                if (this.enabledFeatures.has("dmm") && this.enabledFeatures.has("sim")) {
                    SecondStageSystem.addDynamicMonitoringModules(bootstrap);
                    SecondStageSystem.addLightAgentDmmModules(bootstrap);
                } else {
                    SecondStageSystem.addNonDynamicMonitoringMetricModule(bootstrap);
                    SecondStageSystem.addLightAgentNonDmmModules(bootstrap);
                }
            }
            if (this.enabledFeatures.has("sim")) {
                this.addSimModules(bootstrap);
            }
            this.context = bootstrap.start();
        }
    }

    private static void addLightAgentNonDmmModules(FrameworkBootstrap bootstrap) {
        log.debug("Installing modules needed by light agent with dynamic monitoring disabled");
        bootstrap.add((Module)new LightAgentNonDmmModule());
    }

    @PreDestroy
    private void destroy() {
        this.destroyed = true;
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.context != null) {
                log.info("Stopping main system with features {}.", (Object)this.enabledFeatures);
                this.context.stop();
                this.context = null;
            }
        }
    }

    private static void addBasicModules(FrameworkBootstrap bootstrap) {
        log.debug("Installing modules needed for the machine agent");
        bootstrap.add((Module)new LegacyAgentModule()).add((Module)new AgentExtensionsModule()).add((Module)new AgentEventsModule()).add((Module)new LightSystemAgentModule()).add((Module)new SimMachineIdsModule());
    }

    private static void addLightAgentDmmModules(FrameworkBootstrap bootstrap) {
        log.debug("Installing modules needed by light agent with dynamic monitoring enabled");
        bootstrap.add((Module)new LightAgentDmmModule());
    }

    private static void addDynamicMonitoringModules(FrameworkBootstrap bootstrap) {
        log.debug("Installing Dynamic Monitoring Modules");
        bootstrap.add((Module)new AgentDynamicMonitoringModule());
        bootstrap.add((Module)new AgentDynamicMonitoringMetricsModule());
    }

    private static void addNonDynamicMonitoringMetricModule(FrameworkBootstrap bootstrap) {
        log.debug("Installing legacy agent metrics modules");
        bootstrap.add((Module)new AgentMetricsModule());
    }

    private void addSimModules(FrameworkBootstrap bootstrap) {
        log.debug("Installing SIM modules");
        bootstrap.add((Module)new MonitorModule()).add((Module)new SamModule());
    }

    @Generated
    void setEnabledFeatures(Features enabledFeatures) {
        this.enabledFeatures = enabledFeatures;
    }
}

