/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.logOperations;

import com.appdynamics.agent.sim.logOperations.ADRollingRandomAccessFileAppender;
import com.appdynamics.agent.sim.logOperations.LogCaptureConstants;
import com.appdynamics.agent.sim.logOperations.LoggerInfo;
import com.appdynamics.agent.sim.logOperations.OperationInfo;
import com.singularity.ee.agent.appagent.kernel.AgentRestRequestFactory;
import com.singularity.ee.agent.util.log4j.ADLevel;
import com.singularity.ee.agent.util.log4j.ADLoggerFactory;
import com.singularity.ee.agent.util.log4j.IADLogger;
import com.singularity.ee.agent.util.log4j.Log4J2Logger;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.sim.simagentoperations.LogHandlerParameters;
import com.singularity.ee.rest.controller.request.spi.IFileUploadRequest;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.spi.IHttpExecutionResponse;
import com.singularity.ee.util.string.StringOperations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCaptureHandler
implements LogCaptureConstants {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogCaptureHandler.class);
    private final IADLogger logger = ADLoggerFactory.getLogger((String)"com.singularity.ops.logs.LogCaptureHandler");
    private String installDirectory;
    private String operationId;
    private String controllerHost;
    private int port;
    private String machineId;
    private String logsDirectory;
    public static volatile int maxNewLoggers = 20;
    private int nNewLoggersCreated = 0;
    private final boolean isLog4J2;
    private volatile OperationInfo activeUploadLogOperation = null;
    private volatile List<String> newLoggers = new ArrayList<String>();

    public LogCaptureHandler(String controllerHost, int port, String machineId, String operationId, String logsDirectory, String installDirectory) {
        this.controllerHost = controllerHost;
        this.port = port;
        this.machineId = machineId;
        this.operationId = operationId;
        this.logsDirectory = logsDirectory;
        this.installDirectory = installDirectory;
        this.isLog4J2 = ADLoggerFactory.isIsLog4J2();
    }

    public boolean handleCaptureLogOperation(LogHandlerParameters operation) {
        String loggerName;
        if (this.activeUploadLogOperation != null) {
            this.logger.warn("Dropping operation [" + String.valueOf(operation) + "] as an upload log operation is already active.");
            return false;
        }
        if (operation == null) {
            this.logger.warn("Incorrect operation, no properties provided");
            return false;
        }
        String logLevel = operation.getLoggerLevel() != null ? operation.getLoggerLevel().toString() : null;
        String string = loggerName = operation.getLoggerName() != null ? operation.getLoggerName().toString() : null;
        if (logLevel == null || loggerName == null) {
            OperationInfo operationInfo;
            this.activeUploadLogOperation = operationInfo = new OperationInfo(OperationInfo.OperationType.UPLOAD_LOGS, operation.getOperationId());
            this.logger.info("Operation to upload current logs started.");
        } else {
            boolean isLoggerNameNull = StringUtils.isBlank((CharSequence)loggerName);
            int durationInMins = (int)operation.getDurationInMins();
            if (this.isLogLevelValid(logLevel, operation) && (isLoggerNameNull || this.isLoggerNameValid(loggerName, operation))) {
                ADLevel level = (ADLevel)EnumHelper.getEnum(ADLevel.class, (String)logLevel.toUpperCase());
                OperationInfo operationInfo = new OperationInfo(System.currentTimeMillis(), (long)(durationInMins * 60 * 1000), OperationInfo.OperationType.UPLOAD_LOGS, operation.getOperationId(), operation);
                ArrayList<IADLogger> targetLoggers = new ArrayList<IADLogger>();
                if (StringUtils.isNotBlank((CharSequence)loggerName)) {
                    IADLogger targetLogger = ADLoggerFactory.getLogger((String)loggerName);
                    targetLoggers.add(targetLogger);
                } else {
                    for (org.apache.logging.log4j.Logger aLogger : ((LoggerContext)LogManager.getContext((boolean)false)).getLoggers()) {
                        if (StringUtils.isBlank((CharSequence)aLogger.getName())) continue;
                        IADLogger targetLogger = ADLoggerFactory.getLogger((String)aLogger.getName());
                        targetLoggers.add(targetLogger);
                    }
                }
                for (IADLogger targetLogger : targetLoggers) {
                    LoggerInfo loggerInfo = new LoggerInfo(targetLogger.getName(), targetLogger.getLevel());
                    operationInfo.addLogger(loggerInfo);
                }
                for (IADLogger targetLogger : targetLoggers) {
                    targetLogger.setLevel(level);
                }
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.updateLoggers();
                this.activeUploadLogOperation = operationInfo;
                String logCaptureStartedMsg = String.format("Capture log operation started for logger [%s], logLevel [%s], for [%d] mins.", loggerName, logLevel, durationInMins);
                this.logger.info(logCaptureStartedMsg);
            }
        }
        return true;
    }

    private boolean isLoggerNameValid(String loggerName, LogHandlerParameters operation) {
        if (StringOperations.isEmpty((String)loggerName)) {
            this.logger.error("No logger name specified. The operation [" + String.valueOf(operation) + "] will not be executed.");
            return false;
        }
        if (ADLoggerFactory.exists((String)loggerName) != null) {
            return true;
        }
        for (org.apache.logging.log4j.Logger aLogger : ((LoggerContext)LogManager.getContext((boolean)false)).getLoggers()) {
            if (!aLogger.getName().startsWith(loggerName) || aLogger.getName().length() <= loggerName.length() || aLogger.getName().charAt(loggerName.length()) != '.') continue;
            return true;
        }
        IADLogger targetLogger = null;
        try {
            if (this.nNewLoggersCreated >= maxNewLoggers) {
                this.logger.error("Maximum number [" + this.nNewLoggersCreated + "] of new loggers have been created. Logger for loggerName [" + loggerName + "] will not be created");
                return false;
            }
            targetLogger = this.createLogger(loggerName);
        }
        catch (Exception e) {
            this.logger.error("Error creating a logger for loggerName [" + loggerName + "] - ", (Throwable)e);
            return false;
        }
        if (targetLogger == null) {
            this.logger.error("The logger name [" + loggerName + "] doesn't exist. The operation [" + String.valueOf(operation) + "] will not be executed.");
            return false;
        }
        ++this.nNewLoggersCreated;
        return true;
    }

    private boolean isLogLevelValid(String logLevel, LogHandlerParameters operation) {
        if (StringOperations.isEmpty((String)logLevel)) {
            this.logger.error("No target log level specified. The operation [" + String.valueOf(operation) + "] will not be executed.");
            return false;
        }
        String s = StringOperations.toUppercaseEnglishLocale((String)logLevel);
        if (s.equals("ALL") || s.equals("DEBUG") || s.equals("INFO") || s.equals("WARN") || s.equals("ERROR") || s.equals("FATAL") || s.equals("OFF") || s.equals("TRACE")) {
            return true;
        }
        this.logger.error("Invalid target log level [" + logLevel + "] specified. The operation [" + String.valueOf(operation) + "] will not be executed.");
        return false;
    }

    private IADLogger createLogger(String loggerName) {
        IADLogger targetLogger = ADLoggerFactory.getLogger((String)loggerName);
        if (this.isLog4J2) {
            if (!(targetLogger instanceof Log4J2Logger)) {
                this.logger.error("Logger is not Log4J2Logger! Cannot create appenders and loggers for " + loggerName);
                return null;
            }
            ADRollingRandomAccessFileAppender adRollingRandomAccessFileAppender = new ADRollingRandomAccessFileAppender(this.logsDirectory, "CustomLogRequest.log");
            RollingRandomAccessFileAppender rollingRandomAccessFileAppender = adRollingRandomAccessFileAppender.createAppender();
            rollingRandomAccessFileAppender.start();
            ((Log4J2Logger)targetLogger).addAppender((Appender)rollingRandomAccessFileAppender);
            targetLogger.setLevel(ADLevel.OFF);
            targetLogger.setAdditivity(false);
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.updateLoggers();
            this.newLoggers.add(loggerName);
            return targetLogger;
        }
        this.logger.error("Could not determine class of targetLogger. Cannot create logger for " + loggerName);
        return null;
    }

    public OperationInfo getActiveUploadLogOperation() {
        return this.activeUploadLogOperation;
    }

    public void setActiveUploadLogOperation(OperationInfo activeUploadLogOperation) {
        this.activeUploadLogOperation = activeUploadLogOperation;
    }

    private static void zipDirectory(File directory, String parentDirectoryName, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    LogCaptureHandler.zipDirectory(file, parentDirectoryName + "/" + file.getName(), zos);
                    continue;
                }
                LogCaptureHandler.zipFile(file, parentDirectoryName, zos);
            }
        }
    }

    private static void zipFile(File file, String parentDirectoryName, ZipOutputStream zos) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            String entryName = parentDirectoryName + "/" + file.getName();
            ZipEntry zipEntry = new ZipEntry(entryName);
            zos.putNextEntry(zipEntry);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                zos.write(buffer, 0, length);
            }
        }
    }

    private static void zipRecentFiles(File directory, String parentDirectoryName, long startTime, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                long startTimeInSeconds;
                long fileLastModifiedInSeconds = file.lastModified() / 1000L;
                if (fileLastModifiedInSeconds < (startTimeInSeconds = startTime / 1000L)) continue;
                if (file.isDirectory()) {
                    LogCaptureHandler.zipRecentFiles(file, parentDirectoryName + "/" + file.getName(), startTime, zos);
                    continue;
                }
                LogCaptureHandler.zipFile(file, parentDirectoryName, zos);
            }
        }
    }

    public boolean zipAgentLogs() {
        try {
            String operationId = this.activeUploadLogOperation.getOperationId();
            String directoryPath = this.logsDirectory;
            String zipFilePath = this.installDirectory + "/" + operationId + ".zip";
            File directoryToZip = new File(directoryPath);
            File zipFile = new File(zipFilePath);
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            if (this.activeUploadLogOperation.isJustZipAndUploadLogs()) {
                LogCaptureHandler.zipDirectory(directoryToZip, directoryToZip.getName(), zos);
            } else {
                LogCaptureHandler.zipRecentFiles(directoryToZip, directoryToZip.getName(), this.activeUploadLogOperation.getStartTime(), zos);
            }
            zos.close();
            log.info("Zip file created successfully: " + zipFile.getAbsolutePath());
            log.info("Call to file upload servlet will be made ");
            this.uploadFile(zipFile, "machine_agent_operation", (ILogger)this.logger, operationId);
        }
        catch (IOException e) {
            log.error("Error creating zip file for machine logs upload : ");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean uploadFile(File zipFile, String action, ILogger logger, String operationId) {
        try {
            ArrayList<NameValuePair> paramslist = new ArrayList<NameValuePair>();
            paramslist.add(new NameValuePair("action", action));
            paramslist.add(new NameValuePair("operation-id", operationId));
            IFileUploadRequest request = AgentRestRequestFactory.getAgentRESTRequestFactory().getFileUploadRequest(this.controllerHost, this.port, this.machineId, logger, paramslist);
            request.addFile(zipFile);
            IHttpExecutionResponse response = request.sendRequest();
            if (response.isStatusNotOk() || response.isExceptionHappened()) {
                log.error("http execution response to upload machine agent logs failed");
                boolean bl = false;
                return bl;
            }
            log.info("Zip File sent to Controller Successfully");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Error Uploading Machine Agent Log Zip File");
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.deleteQuietly((File)zipFile);
        }
    }

    public void finishOperation() {
        boolean success = this.zipAgentLogs();
        this.setActiveUploadLogOperation(null);
    }

    public void resetLoggers() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        context.reconfigure();
        if (this.newLoggers != null && !this.newLoggers.isEmpty()) {
            for (String loggerName : this.newLoggers) {
                IADLogger logger = ADLoggerFactory.getLogger((String)loggerName);
                logger.setLevel(ADLevel.OFF);
            }
        }
        context.updateLoggers();
    }
}

