/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.log;

import com.appdynamics.agent.sim.log.SimAgentRepLogger;
import com.appdynamics.agent.sim.log.SimAgentRepLoggerMessageLimit;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.singularity.ee.util.system.SystemUtilsTranslateable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimAgentRepetitiveLoggingModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimAgentRepetitiveLoggingModule.class);
    @VisibleForTesting
    static final long DEFAULT_MESSAGE_LIMIT = 1L;
    @VisibleForTesting
    static final long DEFAULT_CACHE_EXPIRY_TIME_MINS = 5L;
    @VisibleForTesting
    static final int DEFAULT_CACHE_SIZE = 1000;
    private LoadingCache<String, AtomicLong> messageCache;

    protected void configure() {
        this.bind(SimAgentRepetitiveLogger.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    @SimAgentRepLogger
    @VisibleForTesting
    LoadingCache<String, AtomicLong> provideCache() {
        long turnoverTime = (Long)this.getTurnoverTimeMins().get();
        log.info("The turnover time for the SIM agent repetitive logger is {} minutes", (Object)turnoverTime);
        int maxCacheSize = this.getCacheSize();
        log.info("The cache size for the SIM agent repetitive logger is {}", (Object)maxCacheSize);
        this.messageCache = CacheBuilder.newBuilder().expireAfterWrite(turnoverTime, TimeUnit.MINUTES).maximumSize((long)maxCacheSize).build((CacheLoader)new CacheLoader<String, AtomicLong>(){

            public AtomicLong load(String key) throws Exception {
                return new AtomicLong(0L);
            }
        });
        return this.messageCache;
    }

    @Provides
    @Singleton
    @SimAgentRepLogger
    @VisibleForTesting
    Supplier<Long> getTurnoverTimeMins() {
        return new Supplier<Long>(){

            public Long get() {
                return SystemUtilsTranslateable.getLongProperty((String)"appdynamics.machine.agent.repetitiveLogging.turnoverTimeInMinutes", (long)5L);
            }
        };
    }

    @Provides
    @Singleton
    @SimAgentRepLoggerMessageLimit
    @VisibleForTesting
    Supplier<Long> getMessageLimit() {
        return new Supplier<Long>(){

            public Long get() {
                return SystemUtilsTranslateable.getLongProperty((String)"appdynamics.machine.agent.repetitiveLogging.messageLimit", (long)1L);
            }
        };
    }

    @VisibleForTesting
    int getCacheSize() {
        return SystemUtilsTranslateable.getIntProperty((String)"appdynamics.machine.agent.repetitiveLogging.maxCacheSize", (int)1000);
    }
}

