/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.log;

import com.appdynamics.agent.sim.log.SimAgentRepLogger;
import com.appdynamics.agent.sim.log.SimAgentRepLoggerMessageLimit;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimAgentRepetitiveLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimAgentRepetitiveLogger.class);
    private static final String REP_LOGGER_USED_MESSAGE = "The next message will be logged with the SIM agent repetitive logger. The maximum number of times it will be logged every {} minutes is {}.";
    private final LoadingCache<String, AtomicLong> messageCache;
    private final Supplier<Long> turnoverTimeSupplier;
    private final Supplier<Long> messageLimitSupplier;

    @Inject
    public SimAgentRepetitiveLogger(@SimAgentRepLogger LoadingCache<String, AtomicLong> messageCache, @SimAgentRepLogger Supplier<Long> turnoverTimeSupplier, @SimAgentRepLoggerMessageLimit Supplier<Long> messageLimitSupplier) {
        this.messageCache = messageCache;
        this.turnoverTimeSupplier = turnoverTimeSupplier;
        this.messageLimitSupplier = messageLimitSupplier;
    }

    public void info(Logger logger, String message, Object ... args) {
        if (this.shouldLog(message)) {
            logger.info(message, args);
        }
    }

    public void debug(Logger logger, String message, Object ... args) {
        if (this.shouldLog(message)) {
            this.logDebugRepLoggerIsUsed();
            logger.debug(message, args);
        }
    }

    public void warn(Logger logger, String message, Object ... args) {
        if (this.shouldLog(message)) {
            logger.warn(message, args);
        }
    }

    public void error(Logger logger, String message, Object ... args) {
        if (this.shouldLog(message)) {
            logger.error(message, args);
        }
    }

    @VisibleForTesting
    boolean shouldLog(String message) {
        AtomicLong messageCount = (AtomicLong)this.messageCache.getUnchecked((Object)message);
        return messageCount.getAndIncrement() < (Long)this.messageLimitSupplier.get();
    }

    @VisibleForTesting
    void logDebugRepLoggerIsUsed() {
        log.debug(REP_LOGGER_USED_MESSAGE, this.turnoverTimeSupplier.get(), this.messageLimitSupplier.get());
    }
}

