/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.lightagent;

import com.appdynamics.agent.sim.lightagent.LightAgent;
import com.appdynamics.agent.sim.lightagent.LightAgentMachinePropertiesFactory;
import com.appdynamics.agent.sim.lightagent.MetricGenerationServiceFactory;
import com.appdynamics.agent.sim.lightagent.MetricsServiceFactory;
import com.appdynamics.agent.sim.lightagent.SystemAgentMetricSenderFactory;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.common.rest.machines.ContainerType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.singularity.ee.agent.commonservices.eventgeneration.IEventGenerationService;
import com.singularity.ee.agent.commonservices.eventgeneration.events.EventsForTimeslice;
import com.singularity.ee.agent.commonservices.eventgeneration.events.IEventSubscriber;
import com.singularity.ee.agent.commonservices.metricgeneration.MetricGenerationService;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.IMetricSubscriber;
import com.singularity.ee.agent.systemagent.components.monitormanager.managed.SystemAgentMetricSender;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.logging.Slf4JLogger;
import com.singularity.ee.util.spi.IAgentScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightSystemAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LightSystemAgent.class);
    private final IEventGenerationService eventGenerationService;
    private final MetricGenerationService metricGenerationService;
    private final SystemAgentMetricSender systemAgentMetricSender;
    private final ILogger logger;
    private final IAgentScheduledExecutorService scheduler;
    private final MetricsService metricsService;
    private final MachineProperties containerProperties;
    private final String machineInstanceId;
    private final long simMachineId;
    private long lastRegisteredTime;
    private Optional<ContainerType> containerType;

    @Inject
    @VisibleForTesting
    LightSystemAgent(@LightAgent Provider<IEventGenerationService> eventGenerationServiceProvider, IAgentScheduledExecutorService agentScheduledExecutorService, SystemAgentMetricSenderFactory metricSenderFactory, MetricGenerationServiceFactory metricGenerationServiceFactory, MetricsServiceFactory metricsServiceFactory, LightAgentMachinePropertiesFactory lightAgentMachinePropertiesFactory, @Assisted String machineInstanceId, @Assisted long simMachineId) {
        this.machineInstanceId = machineInstanceId;
        this.simMachineId = simMachineId;
        this.logger = new Slf4JLogger(log);
        this.scheduler = agentScheduledExecutorService;
        this.eventGenerationService = (IEventGenerationService)eventGenerationServiceProvider.get();
        this.eventGenerationService.setEventSubscriber((IEventSubscriber)new EventSender());
        this.systemAgentMetricSender = metricSenderFactory.create(machineInstanceId, AgentType.MACHINE_AGENT, this.eventGenerationService);
        this.metricGenerationService = metricGenerationServiceFactory.create(this.eventGenerationService);
        this.metricGenerationService.setMetricSubscriber((IMetricSubscriber)this.systemAgentMetricSender);
        this.metricsService = metricsServiceFactory.create(this.metricGenerationService.getMetricReporterFactory(), simMachineId);
        this.containerProperties = lightAgentMachinePropertiesFactory.create();
        this.containerType = Optional.absent();
    }

    public void stop() {
        if (this.eventGenerationService != null) {
            this.eventGenerationService.flush();
        }
        if (this.metricGenerationService != null) {
            this.metricGenerationService.shutdown();
        }
    }

    @Generated
    public IEventGenerationService getEventGenerationService() {
        return this.eventGenerationService;
    }

    @Generated
    public MetricGenerationService getMetricGenerationService() {
        return this.metricGenerationService;
    }

    @Generated
    public SystemAgentMetricSender getSystemAgentMetricSender() {
        return this.systemAgentMetricSender;
    }

    @Generated
    public ILogger getLogger() {
        return this.logger;
    }

    @Generated
    public IAgentScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Generated
    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    @Generated
    public MachineProperties getContainerProperties() {
        return this.containerProperties;
    }

    @Generated
    public String getMachineInstanceId() {
        return this.machineInstanceId;
    }

    @Generated
    public long getSimMachineId() {
        return this.simMachineId;
    }

    @Generated
    public long getLastRegisteredTime() {
        return this.lastRegisteredTime;
    }

    @Generated
    public Optional<ContainerType> getContainerType() {
        return this.containerType;
    }

    @Generated
    public void setLastRegisteredTime(long lastRegisteredTime) {
        this.lastRegisteredTime = lastRegisteredTime;
    }

    @Generated
    public void setContainerType(Optional<ContainerType> containerType) {
        this.containerType = containerType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LightSystemAgent)) {
            return false;
        }
        LightSystemAgent other = (LightSystemAgent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSimMachineId() != other.getSimMachineId()) {
            return false;
        }
        if (this.getLastRegisteredTime() != other.getLastRegisteredTime()) {
            return false;
        }
        IEventGenerationService this$eventGenerationService = this.getEventGenerationService();
        IEventGenerationService other$eventGenerationService = other.getEventGenerationService();
        if (this$eventGenerationService == null ? other$eventGenerationService != null : !this$eventGenerationService.equals(other$eventGenerationService)) {
            return false;
        }
        MetricGenerationService this$metricGenerationService = this.getMetricGenerationService();
        MetricGenerationService other$metricGenerationService = other.getMetricGenerationService();
        if (this$metricGenerationService == null ? other$metricGenerationService != null : !this$metricGenerationService.equals(other$metricGenerationService)) {
            return false;
        }
        SystemAgentMetricSender this$systemAgentMetricSender = this.getSystemAgentMetricSender();
        SystemAgentMetricSender other$systemAgentMetricSender = other.getSystemAgentMetricSender();
        if (this$systemAgentMetricSender == null ? other$systemAgentMetricSender != null : !((Object)((Object)this$systemAgentMetricSender)).equals((Object)other$systemAgentMetricSender)) {
            return false;
        }
        ILogger this$logger = this.getLogger();
        ILogger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        IAgentScheduledExecutorService this$scheduler = this.getScheduler();
        IAgentScheduledExecutorService other$scheduler = other.getScheduler();
        if (this$scheduler == null ? other$scheduler != null : !this$scheduler.equals(other$scheduler)) {
            return false;
        }
        MetricsService this$metricsService = this.getMetricsService();
        MetricsService other$metricsService = other.getMetricsService();
        if (this$metricsService == null ? other$metricsService != null : !this$metricsService.equals(other$metricsService)) {
            return false;
        }
        MachineProperties this$containerProperties = this.getContainerProperties();
        MachineProperties other$containerProperties = other.getContainerProperties();
        if (this$containerProperties == null ? other$containerProperties != null : !this$containerProperties.equals(other$containerProperties)) {
            return false;
        }
        String this$machineInstanceId = this.getMachineInstanceId();
        String other$machineInstanceId = other.getMachineInstanceId();
        if (this$machineInstanceId == null ? other$machineInstanceId != null : !this$machineInstanceId.equals(other$machineInstanceId)) {
            return false;
        }
        Optional<ContainerType> this$containerType = this.getContainerType();
        Optional<ContainerType> other$containerType = other.getContainerType();
        return !(this$containerType == null ? other$containerType != null : !this$containerType.equals(other$containerType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LightSystemAgent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $simMachineId = this.getSimMachineId();
        result = result * 59 + (int)($simMachineId >>> 32 ^ $simMachineId);
        long $lastRegisteredTime = this.getLastRegisteredTime();
        result = result * 59 + (int)($lastRegisteredTime >>> 32 ^ $lastRegisteredTime);
        IEventGenerationService $eventGenerationService = this.getEventGenerationService();
        result = result * 59 + ($eventGenerationService == null ? 43 : $eventGenerationService.hashCode());
        MetricGenerationService $metricGenerationService = this.getMetricGenerationService();
        result = result * 59 + ($metricGenerationService == null ? 43 : $metricGenerationService.hashCode());
        SystemAgentMetricSender $systemAgentMetricSender = this.getSystemAgentMetricSender();
        result = result * 59 + ($systemAgentMetricSender == null ? 43 : ((Object)((Object)$systemAgentMetricSender)).hashCode());
        ILogger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        IAgentScheduledExecutorService $scheduler = this.getScheduler();
        result = result * 59 + ($scheduler == null ? 43 : $scheduler.hashCode());
        MetricsService $metricsService = this.getMetricsService();
        result = result * 59 + ($metricsService == null ? 43 : $metricsService.hashCode());
        MachineProperties $containerProperties = this.getContainerProperties();
        result = result * 59 + ($containerProperties == null ? 43 : $containerProperties.hashCode());
        String $machineInstanceId = this.getMachineInstanceId();
        result = result * 59 + ($machineInstanceId == null ? 43 : $machineInstanceId.hashCode());
        Optional<ContainerType> $containerType = this.getContainerType();
        result = result * 59 + ($containerType == null ? 43 : $containerType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LightSystemAgent(eventGenerationService=" + String.valueOf(this.getEventGenerationService()) + ", metricGenerationService=" + String.valueOf(this.getMetricGenerationService()) + ", systemAgentMetricSender=" + String.valueOf((Object)this.getSystemAgentMetricSender()) + ", logger=" + String.valueOf(this.getLogger()) + ", scheduler=" + String.valueOf(this.getScheduler()) + ", metricsService=" + String.valueOf(this.getMetricsService()) + ", containerProperties=" + String.valueOf(this.getContainerProperties()) + ", machineInstanceId=" + this.getMachineInstanceId() + ", simMachineId=" + this.getSimMachineId() + ", lastRegisteredTime=" + this.getLastRegisteredTime() + ", containerType=" + String.valueOf(this.getContainerType()) + ")";
    }

    private class EventSender
    implements IEventSubscriber {
        private EventSender() {
        }

        public boolean publish(EventsForTimeslice events) {
            return true;
        }

        public boolean isReady() {
            return true;
        }
    }
}

