/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.lightagent;

import com.appdynamics.agent.sim.dmm.DynamicMonitoringFeatureResolver;
import com.appdynamics.agent.sim.lightagent.LightAgent;
import com.appdynamics.agent.sim.lightagent.LightAgentMetricServiceFactory;
import com.appdynamics.agent.sim.lightagent.MetricsServiceFactory;
import com.appdynamics.agent.sim.metrics.DefaultMetricsService;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.google.common.cache.Cache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.util.Providers;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.IMetricReporterFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LightAgentMetricsServiceFactory
implements MetricsServiceFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LightAgentMetricsServiceFactory.class);
    private final Provider<Cache<String, IMetricAggregator>> cacheProvider;
    private final DynamicMonitoringFeatureResolver dynamicMonitoringFeatureResolver;
    private final LightAgentMetricServiceFactory lightAgentMetricServiceFactory;

    @Inject
    public LightAgentMetricsServiceFactory(@LightAgent Provider<Cache<String, IMetricAggregator>> cacheProvider, DynamicMonitoringFeatureResolver dynamicMonitoringFeatureResolver, LightAgentMetricServiceFactory lightAgentMetricServiceFactory) {
        this.cacheProvider = cacheProvider;
        this.dynamicMonitoringFeatureResolver = dynamicMonitoringFeatureResolver;
        this.lightAgentMetricServiceFactory = lightAgentMetricServiceFactory;
    }

    @Override
    public MetricsService create(IMetricReporterFactory metricReporterFactory, long simMachineId) {
        DefaultMetricsService defaultMetricService = new DefaultMetricsService((Provider<IMetricReporterFactory>)Providers.of((Object)metricReporterFactory), (Cache<String, IMetricAggregator>)((Cache)this.cacheProvider.get()));
        if (!this.dynamicMonitoringFeatureResolver.isDmmAllowed()) {
            log.debug("Dynamic monitoring mode is disabled. Returning default metrics service for the light system agent with SIM machine ID " + simMachineId);
            return defaultMetricService;
        }
        MetricsService categoryMetricService = this.lightAgentMetricServiceFactory.create(simMachineId, defaultMetricService);
        log.debug("Dynamic monitoring mode is enabled. Returning dmm metrics service for the light system agent with SIM machine ID " + simMachineId);
        return categoryMetricService;
    }
}

