/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.agent.sim.lightagent;

import com.appdynamics.agent.sim.dmm.CategoryTree;
import com.appdynamics.agent.sim.dmm.CategoryTreeImpl;
import com.appdynamics.agent.sim.dmm.MetricCategoryDataSet;
import com.appdynamics.agent.sim.dmm.OverridingDataSet;
import com.appdynamics.agent.sim.lightagent.LightAgent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.List;

class LightAgentCategoryTreeImpl
implements CategoryTree {
    private final MetricCategoryDataSet originalCategoryDataSet;
    private final MetricCategoryDataSet overriderCategoryDataSet;
    private final CategoryTreeImpl categoryTreeImpl;

    @Inject
    LightAgentCategoryTreeImpl(@LightAgent MetricCategoryDataSet metricCategoryDataSet, @OverridingDataSet MetricCategoryDataSet overriderDataSet) {
        this.originalCategoryDataSet = metricCategoryDataSet;
        this.overriderCategoryDataSet = overriderDataSet;
        this.categoryTreeImpl = new CategoryTreeImpl(metricCategoryDataSet, overriderDataSet);
        this.buildTree(this.originalCategoryDataSet, this.overriderCategoryDataSet);
    }

    @VisibleForTesting
    LightAgentCategoryTreeImpl(MetricCategoryDataSet metricCategoryDataSet, MetricCategoryDataSet overriderDataSet, CategoryTreeImpl categoryTree) {
        this.originalCategoryDataSet = metricCategoryDataSet;
        this.overriderCategoryDataSet = overriderDataSet;
        this.categoryTreeImpl = categoryTree;
    }

    @Override
    public void buildTree(MetricCategoryDataSet originalCategoryDataSet, MetricCategoryDataSet ... overrideCategoryDataSets) {
        this.categoryTreeImpl.buildTree(originalCategoryDataSet, overrideCategoryDataSets);
    }

    @Override
    public Optional<List<Integer>> findCategories(String metricName) {
        return this.categoryTreeImpl.findCategories(metricName);
    }
}

